/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.metrics;

import com.codahale.metrics.ExponentiallyDecayingReservoir;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.HdrHistogram.AtomicHistogram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdrHistogram
extends Histogram {
    private static final Logger log = LoggerFactory.getLogger(HdrHistogram.class);
    private final AtomicHistogram hdrHistogram;

    public HdrHistogram(AtomicHistogram hdrHistogram) {
        super((Reservoir)new ExponentiallyDecayingReservoir());
        this.hdrHistogram = hdrHistogram;
    }

    public HdrHistogram(long highestTrackableValue, int numberOfSignificantValueDigits) {
        this(new AtomicHistogram(highestTrackableValue, numberOfSignificantValueDigits));
    }

    public long getCount() {
        return this.hdrHistogram.getTotalCount();
    }

    public Snapshot getSnapshot() {
        final AtomicHistogram copy = this.hdrHistogram.copy();
        return new Snapshot(){

            public double getValue(double quantile) {
                return copy.getValueAtPercentile(quantile * 100.0);
            }

            public long[] getValues() {
                return new long[0];
            }

            public int size() {
                return 0;
            }

            public long getMax() {
                return copy.getMaxValue();
            }

            public double getMean() {
                double mean = copy.getMean();
                return Double.isNaN(mean) ? 0.0 : mean;
            }

            public long getMin() {
                long minValue = copy.getMinValue();
                return minValue == Long.MAX_VALUE ? 0L : minValue;
            }

            public double getStdDev() {
                double stdDeviation = copy.getStdDeviation();
                return Double.isNaN(stdDeviation) ? 0.0 : stdDeviation;
            }

            public void dump(OutputStream output) {
                PrintStream printStream;
                try {
                    printStream = new PrintStream(output, false, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                copy.outputPercentileDistribution(printStream, Double.valueOf(1.0));
            }
        };
    }

    public void update(int value) {
        this.update((long)value);
    }

    public void update(long value) {
        try {
            this.hdrHistogram.recordValue(value);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            log.debug("Ignoring value {} for HdrHistogram, it exceeds the highest trackable value {}", (Object)value, (Object)this.hdrHistogram.getHighestTrackableValue());
        }
    }
}

