/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.dashboards.widgets.strategies;

import com.google.common.base.Strings;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.Locale;
import java.util.Map;
import org.graylog2.dashboards.widgets.InvalidWidgetConfigurationException;
import org.graylog2.dashboards.widgets.strategies.ChartWidgetStrategy;
import org.graylog2.indexer.FieldTypeException;
import org.graylog2.indexer.results.HistogramResult;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.plugin.dashboards.widgets.ComputationResult;
import org.graylog2.plugin.dashboards.widgets.WidgetStrategy;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldChartWidgetStrategy
extends ChartWidgetStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(FieldChartWidgetStrategy.class);
    private final String query;
    private final String field;
    private final String statisticalFunction;
    private final Searches searches;
    private final TimeRange timeRange;
    private final String widgetId;

    @AssistedInject
    public FieldChartWidgetStrategy(Searches searches, @Assisted Map<String, Object> config, @Assisted TimeRange timeRange, @Assisted String widgetId) throws InvalidWidgetConfigurationException {
        super(config);
        this.searches = searches;
        this.timeRange = timeRange;
        this.widgetId = widgetId;
        if (!this.checkConfig(config)) {
            throw new InvalidWidgetConfigurationException("Missing or invalid widget configuration. Provided config was: " + config.toString());
        }
        String query = (String)config.get("query");
        this.query = query == null || query.trim().isEmpty() ? "*" : query;
        this.field = (String)config.get("field");
        this.statisticalFunction = (String)config.get("valuetype");
    }

    @Override
    public ComputationResult compute() {
        String filter = null;
        if (!Strings.isNullOrEmpty((String)this.streamId)) {
            filter = "streams:" + this.streamId;
        }
        boolean shouldCalculateCardinality = "cardinality".equalsIgnoreCase(this.statisticalFunction);
        try {
            HistogramResult histogramResult = this.searches.fieldHistogram(this.query, this.field, Searches.DateHistogramInterval.valueOf(this.interval.toString().toUpperCase(Locale.ENGLISH)), filter, this.timeRange, !shouldCalculateCardinality, shouldCalculateCardinality);
            return new ComputationResult(histogramResult.getResults(), histogramResult.tookMs(), histogramResult.getHistogramBoundaries());
        }
        catch (FieldTypeException e) {
            try {
                HistogramResult histogramResult = this.searches.fieldHistogram(this.query, this.field, Searches.DateHistogramInterval.valueOf(this.interval.toString().toUpperCase(Locale.ENGLISH)), filter, this.timeRange, false, shouldCalculateCardinality);
                return new ComputationResult(histogramResult.getResults(), histogramResult.tookMs(), histogramResult.getHistogramBoundaries());
            }
            catch (FieldTypeException e1) {
                String msg = "Could not calculate [" + this.getClass().getCanonicalName() + "] widget <" + this.widgetId + ">. The field was [" + this.field + "]";
                LOG.error(msg, (Throwable)e1);
                throw new RuntimeException(msg, e1);
            }
        }
    }

    private boolean checkConfig(Map<String, Object> config) {
        return config.containsKey("field") && config.containsKey("valuetype") && config.containsKey("renderer") && config.containsKey("interpolation") && config.containsKey("interval");
    }

    public static interface Factory
    extends WidgetStrategy.Factory<FieldChartWidgetStrategy> {
        @Override
        public FieldChartWidgetStrategy create(Map<String, Object> var1, TimeRange var2, String var3);
    }
}

