/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;

public class ElasticsearchException
extends RuntimeException {
    private final List<String> errorDetails;

    public ElasticsearchException() {
        this.errorDetails = Collections.emptyList();
    }

    public ElasticsearchException(String message) {
        super(message);
        this.errorDetails = Collections.emptyList();
    }

    public ElasticsearchException(String message, Throwable cause) {
        super(message, cause);
        this.errorDetails = Collections.emptyList();
    }

    public ElasticsearchException(Throwable cause) {
        super(cause);
        this.errorDetails = Collections.emptyList();
    }

    public ElasticsearchException(String message, List<String> errorDetails) {
        super(message);
        this.errorDetails = ImmutableList.copyOf(errorDetails);
    }

    public ElasticsearchException(String message, List<String> errorDetails, Throwable cause) {
        super(message, cause);
        this.errorDetails = ImmutableList.copyOf(errorDetails);
    }

    public ElasticsearchException(List<String> errorDetails, Throwable cause) {
        super(cause);
        this.errorDetails = ImmutableList.copyOf(errorDetails);
    }

    public List<String> getErrorDetails() {
        return this.errorDetails;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder(super.getMessage());
        if (!this.errorDetails.isEmpty()) {
            sb.append("\n\n");
            this.errorDetails.forEach(sb::append);
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("message", (Object)this.getMessage()).add("errorDetails", this.getErrorDetails()).toString();
    }
}

