/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.cluster;

import com.github.zafarkhaja.semver.Version;
import io.searchbox.client.JestClient;
import io.searchbox.core.Ping;
import java.util.Optional;
import javax.inject.Inject;
import org.graylog2.indexer.ElasticsearchException;
import org.graylog2.indexer.cluster.jest.JestUtils;

public class Node {
    private final JestClient jestClient;

    @Inject
    public Node(JestClient jestClient) {
        this.jestClient = jestClient;
    }

    public Optional<Version> getVersion() {
        Ping request = new Ping.Builder().build();
        Object jestResult = JestUtils.execute(this.jestClient, request, () -> "Unable to retrieve Elasticsearch version");
        return Optional.ofNullable(jestResult.getJsonObject().path("version").path("number").asText(null)).map(this::parseVersion);
    }

    private Version parseVersion(String version) {
        try {
            return Version.valueOf((String)version);
        }
        catch (Exception e) {
            throw new ElasticsearchException("Unable to parse Elasticsearch version: " + version, (Throwable)e);
        }
    }
}

