/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.converters;

import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.util.Map;
import org.graylog2.plugin.inputs.Converter;

public class NumericConverter
extends Converter {
    public NumericConverter(Map<String, Object> config) {
        super(Converter.Type.NUMERIC, config);
    }

    @Override
    public Object convert(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        Number result = Ints.tryParse((String)value);
        if (result != null) {
            return result;
        }
        result = Longs.tryParse((String)value);
        if (result != null) {
            return result;
        }
        result = Doubles.tryParse((String)value);
        if (result != null) {
            return result;
        }
        return value;
    }

    @Override
    public boolean buildsMultipleFields() {
        return false;
    }
}

