/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.outputs;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.collect.Maps;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import org.graylog2.Configuration;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.messages.Messages;
import org.graylog2.outputs.ElasticSearchOutput;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.shared.journal.Journal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingBatchedESOutput
extends ElasticSearchOutput {
    private static final Logger log = LoggerFactory.getLogger(BlockingBatchedESOutput.class);
    private final int maxBufferSize;
    private final Timer processTime;
    private final Histogram batchSize;
    private final Meter bufferFlushes;
    private final Meter bufferFlushFailures;
    private final Meter bufferFlushesRequested;
    private volatile List<Map.Entry<IndexSet, Message>> buffer;
    private static final AtomicInteger activeFlushThreads = new AtomicInteger(0);
    private final AtomicLong lastFlushTime = new AtomicLong();
    private final int outputFlushInterval;

    @AssistedInject
    public BlockingBatchedESOutput(MetricRegistry metricRegistry, Messages messages, Configuration serverConfiguration, Journal journal, @Assisted Stream stream, @Assisted org.graylog2.plugin.configuration.Configuration configuration) {
        this(metricRegistry, messages, serverConfiguration, journal);
    }

    @Inject
    public BlockingBatchedESOutput(MetricRegistry metricRegistry, Messages messages, Configuration serverConfiguration, Journal journal) {
        super(metricRegistry, messages, journal);
        this.maxBufferSize = serverConfiguration.getOutputBatchSize();
        this.outputFlushInterval = serverConfiguration.getOutputFlushInterval();
        this.processTime = metricRegistry.timer(MetricRegistry.name(this.getClass(), (String[])new String[]{"processTime"}));
        this.batchSize = metricRegistry.histogram(MetricRegistry.name(this.getClass(), (String[])new String[]{"batchSize"}));
        this.bufferFlushes = metricRegistry.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{"bufferFlushes"}));
        this.bufferFlushFailures = metricRegistry.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{"bufferFlushFailures"}));
        this.bufferFlushesRequested = metricRegistry.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{"bufferFlushesRequested"}));
        this.buffer = new ArrayList<Map.Entry<IndexSet, Message>>(this.maxBufferSize);
    }

    @Override
    public void write(Message message) throws Exception {
        for (IndexSet indexSet : message.getIndexSets()) {
            this.writeMessageEntry(Maps.immutableEntry((Object)indexSet, (Object)message));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMessageEntry(Map.Entry<IndexSet, Message> entry) throws Exception {
        List<Map.Entry<IndexSet, Message>> flushBatch = null;
        BlockingBatchedESOutput blockingBatchedESOutput = this;
        synchronized (blockingBatchedESOutput) {
            this.buffer.add(entry);
            if (this.buffer.size() >= this.maxBufferSize) {
                flushBatch = this.buffer;
                this.buffer = new ArrayList<Map.Entry<IndexSet, Message>>(this.maxBufferSize);
            }
        }
        if (flushBatch != null) {
            this.flush(flushBatch);
        }
    }

    private void flush(List<Map.Entry<IndexSet, Message>> messages) {
        if (messages.isEmpty()) {
            return;
        }
        activeFlushThreads.incrementAndGet();
        if (log.isDebugEnabled()) {
            log.debug("Starting flushing {} messages, flush threads active {}", (Object)messages.size(), (Object)activeFlushThreads.get());
        }
        try (Timer.Context ignored = this.processTime.time();){
            this.lastFlushTime.set(System.nanoTime());
            this.writeMessageEntries(messages);
            this.batchSize.update(messages.size());
            this.bufferFlushes.mark();
        }
        catch (Exception e) {
            log.error("Unable to flush message buffer", (Throwable)e);
            this.bufferFlushFailures.mark();
        }
        activeFlushThreads.decrementAndGet();
        log.debug("Flushing {} messages completed", (Object)messages.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceFlushIfTimedout() {
        List<Map.Entry<IndexSet, Message>> flushBatch;
        if (this.lastFlushTime.get() != 0L && (long)this.outputFlushInterval > TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - this.lastFlushTime.get())) {
            return;
        }
        BlockingBatchedESOutput blockingBatchedESOutput = this;
        synchronized (blockingBatchedESOutput) {
            flushBatch = this.buffer;
            this.buffer = new ArrayList<Map.Entry<IndexSet, Message>>(this.maxBufferSize);
        }
        if (flushBatch != null) {
            this.bufferFlushesRequested.mark();
            this.flush(flushBatch);
        }
    }

    public static class Descriptor
    extends ElasticSearchOutput.Descriptor {
        public Descriptor() {
            super("Blocking Batched Elasticsearch Output", false, "", "Elasticsearch Output with Batching (blocking)");
        }
    }

    public static class Config
    extends ElasticSearchOutput.Config {
    }

    public static interface Factory
    extends ElasticSearchOutput.Factory {
    }
}

