/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.models.system.responses;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Function;
import org.graylog2.rest.models.system.responses.AutoValue_LocalesResponse;
import org.graylog2.rest.models.system.responses.AutoValue_LocalesResponse_LocaleDescription;

@JsonAutoDetect
@AutoValue
public abstract class LocalesResponse {
    @JsonProperty(value="locales")
    public abstract ImmutableMap<String, LocaleDescription> locales();

    public static LocalesResponse create(Locale[] locales) {
        ImmutableMap localeMap = (ImmutableMap)Arrays.stream(locales).map(LocaleDescription::create).collect(ImmutableMap.toImmutableMap(LocaleDescription::languageTag, Function.identity()));
        return new AutoValue_LocalesResponse((ImmutableMap<String, LocaleDescription>)localeMap);
    }

    @JsonAutoDetect
    @AutoValue
    public static abstract class LocaleDescription {
        @JsonProperty(value="language_tag")
        public abstract String languageTag();

        @JsonProperty(value="display_name")
        public abstract String displayName();

        public static LocaleDescription create(Locale locale) {
            return LocaleDescription.create(locale.toLanguageTag(), locale.getDisplayName(Locale.ENGLISH));
        }

        private static LocaleDescription create(String languageTag, String displayName) {
            return new AutoValue_LocalesResponse_LocaleDescription(languageTag, displayName);
        }
    }
}

