/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.streams.rules;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.database.NotFoundException;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.plugin.streams.StreamRule;
import org.graylog2.plugin.streams.StreamRuleType;
import org.graylog2.rest.resources.streams.responses.SingleStreamRuleSummaryResponse;
import org.graylog2.rest.resources.streams.responses.StreamRuleListResponse;
import org.graylog2.rest.resources.streams.responses.StreamRuleTypeResponse;
import org.graylog2.rest.resources.streams.rules.requests.CreateStreamRuleRequest;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.streams.StreamRuleService;
import org.graylog2.streams.StreamService;
import org.graylog2.streams.events.StreamsChangedEvent;

@RequiresAuthentication
@Api(value="StreamRules", description="Manage stream rules")
@Path(value="/streams/{streamid}/rules")
public class StreamRuleResource
extends RestResource {
    private final StreamRuleService streamRuleService;
    private final StreamService streamService;
    private final ClusterEventBus clusterEventBus;

    @Inject
    public StreamRuleResource(StreamRuleService streamRuleService, StreamService streamService, ClusterEventBus clusterEventBus) {
        this.streamRuleService = streamRuleService;
        this.streamService = streamService;
        this.clusterEventBus = clusterEventBus;
    }

    @POST
    @Timed
    @ApiOperation(value="Create a stream rule")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @AuditEvent(type="server:stream_rule:create")
    public Response create(@ApiParam(name="streamid", value="The stream id this new rule belongs to.", required=true) @PathParam(value="streamid") String streamId, @ApiParam(name="JSON body", required=true) @Valid @NotNull CreateStreamRuleRequest cr) throws NotFoundException, ValidationException {
        this.checkPermission("streams:edit", streamId);
        this.checkNotDefaultStream(streamId, "Cannot add stream rules to the default stream.");
        Stream stream = this.streamService.load(streamId);
        StreamRule streamRule = this.streamRuleService.create(streamId, cr);
        String id = this.streamService.save(streamRule);
        this.clusterEventBus.post(StreamsChangedEvent.create(stream.getId()));
        SingleStreamRuleSummaryResponse response = SingleStreamRuleSummaryResponse.create(id);
        URI streamRuleUri = this.getUriBuilderToSelf().path(StreamRuleResource.class).path("{streamRuleId}").build(new Object[]{streamId, id});
        return Response.created((URI)streamRuleUri).entity((Object)response).build();
    }

    @PUT
    @Path(value="/{streamRuleId}")
    @Timed
    @ApiOperation(value="Update a stream rule")
    @ApiResponses(value={@ApiResponse(code=404, message="Stream or stream rule not found."), @ApiResponse(code=400, message="Invalid JSON Body.")})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @AuditEvent(type="server:stream_rule:update")
    public SingleStreamRuleSummaryResponse update(@ApiParam(name="streamid", value="The stream id this rule belongs to.", required=true) @PathParam(value="streamid") String streamid, @ApiParam(name="streamRuleId", value="The stream rule id we are updating", required=true) @PathParam(value="streamRuleId") String streamRuleId, @ApiParam(name="JSON body", required=true) @Valid @NotNull CreateStreamRuleRequest cr) throws NotFoundException, ValidationException {
        this.checkPermission("streams:edit", streamid);
        this.checkNotDefaultStream(streamid, "Cannot update stream rules on default stream.");
        StreamRule streamRule = this.streamRuleService.load(streamRuleId);
        if (!streamRule.getStreamId().equals(streamid)) {
            throw new NotFoundException("Couldn't update stream rule " + streamRuleId + "in stream " + streamid);
        }
        StreamRuleType streamRuleType = StreamRuleType.fromInteger(cr.type());
        if (null == streamRuleType) {
            throw new BadRequestException("Unknown stream rule type " + cr.type());
        }
        streamRule.setField(cr.field());
        streamRule.setType(streamRuleType);
        streamRule.setInverted(cr.inverted());
        streamRule.setValue(cr.value());
        streamRule.setDescription(cr.description());
        this.streamRuleService.save(streamRule);
        this.clusterEventBus.post(StreamsChangedEvent.create(streamid));
        return SingleStreamRuleSummaryResponse.create(streamRule.getId());
    }

    @POST
    @Path(value="/{streamRuleId}")
    @Timed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @AuditEvent(type="server:stream_rule:update")
    @Deprecated
    public SingleStreamRuleSummaryResponse updateDeprecated(@PathParam(value="streamid") String streamid, @PathParam(value="streamRuleId") String streamRuleId, @Valid @NotNull CreateStreamRuleRequest cr) throws NotFoundException, ValidationException {
        this.checkNotDefaultStream(streamid, "Cannot remove stream rule from default stream.");
        return this.update(streamid, streamRuleId, cr);
    }

    @GET
    @Timed
    @ApiOperation(value="Get a list of all stream rules")
    @Produces(value={"application/json"})
    public StreamRuleListResponse get(@ApiParam(name="streamid", value="The id of the stream whose stream rules we want.", required=true) @PathParam(value="streamid") String streamid) throws NotFoundException {
        this.checkPermission("streams:read", streamid);
        Stream stream = this.streamService.load(streamid);
        List<StreamRule> streamRules = this.streamRuleService.loadForStream(stream);
        return StreamRuleListResponse.create(streamRules.size(), streamRules);
    }

    @GET
    @Path(value="/{streamRuleId}")
    @Timed
    @ApiOperation(value="Get a single stream rules")
    @Produces(value={"application/json"})
    public StreamRule get(@ApiParam(name="streamid", value="The id of the stream whose stream rule we want.", required=true) @PathParam(value="streamid") String streamid, @ApiParam(name="streamRuleId", value="The stream rule id we are getting", required=true) @PathParam(value="streamRuleId") String streamRuleId) throws NotFoundException {
        this.checkPermission("streams:read", streamid);
        return this.streamRuleService.load(streamRuleId);
    }

    @DELETE
    @Path(value="/{streamRuleId}")
    @Timed
    @ApiOperation(value="Delete a stream rule")
    @ApiResponses(value={@ApiResponse(code=404, message="Stream rule not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    @AuditEvent(type="server:stream_rule:delete")
    public void delete(@ApiParam(name="streamid", value="The stream id this new rule belongs to.", required=true) @PathParam(value="streamid") String streamid, @ApiParam(name="streamRuleId", required=true) @PathParam(value="streamRuleId") @NotEmpty String streamRuleId) throws NotFoundException {
        this.checkPermission("streams:edit", streamid);
        this.checkNotDefaultStream(streamid, "Cannot delete stream rule from default stream.");
        StreamRule streamRule = this.streamRuleService.load(streamRuleId);
        if (!streamRule.getStreamId().equals(streamid)) {
            throw new NotFoundException("Couldn't delete stream rule " + streamRuleId + "in stream " + streamid);
        }
        this.streamRuleService.destroy(streamRule);
        this.clusterEventBus.post(StreamsChangedEvent.create(streamid));
    }

    @GET
    @Path(value="/types")
    @Timed
    @ApiOperation(value="Get all available stream types")
    @Produces(value={"application/json"})
    public List<StreamRuleTypeResponse> types(@ApiParam(name="streamid", value="The stream id this new rule belongs to.", required=true) @PathParam(value="streamid") String streamid) {
        ArrayList<StreamRuleTypeResponse> result = new ArrayList<StreamRuleTypeResponse>(StreamRuleType.values().length);
        for (StreamRuleType type : StreamRuleType.values()) {
            result.add(StreamRuleTypeResponse.create(type.getValue(), type.name(), type.getShortDesc(), type.getLongDesc()));
        }
        return result;
    }

    private void checkNotDefaultStream(String streamId, String message) {
        if ("000000000000000000000001".equals(streamId)) {
            throw new BadRequestException(message);
        }
    }
}

