/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.Configuration;
import org.graylog2.configuration.ExposedConfiguration;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="System/Configuration", description="Read-only access to configuration settings")
@Path(value="/system/configuration")
@Produces(value={"application/json"})
public class ConfigurationResource
extends RestResource {
    private final Configuration configuration;

    @Inject
    public ConfigurationResource(Configuration configuration) {
        this.configuration = configuration;
    }

    @GET
    @Timed
    @ApiOperation(value="Get relevant configuration settings and their values")
    public ExposedConfiguration getRelevant() {
        return ExposedConfiguration.create(this.configuration);
    }
}

