/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.inputs;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.graylog2.plugin.IOState;
import org.graylog2.plugin.inputs.MessageInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputRegistry
extends HashSet<IOState<MessageInput>> {
    private static final Logger LOG = LoggerFactory.getLogger(InputRegistry.class);

    public Set<IOState<MessageInput>> getInputStates() {
        return ImmutableSet.copyOf((Collection)this);
    }

    public IOState<MessageInput> getInputState(String inputId) {
        for (IOState inputState : this) {
            if (!((MessageInput)inputState.getStoppable()).getPersistId().equals(inputId)) continue;
            return inputState;
        }
        return null;
    }

    public Set<IOState<MessageInput>> getRunningInputs() {
        ImmutableSet.Builder runningInputs = ImmutableSet.builder();
        for (IOState inputState : this) {
            if (inputState.getState() != IOState.Type.RUNNING) continue;
            runningInputs.add((Object)inputState);
        }
        return runningInputs.build();
    }

    public boolean hasTypeRunning(Class klazz) {
        for (IOState inputState : this) {
            if (!((MessageInput)inputState.getStoppable()).getClass().equals(klazz)) continue;
            return true;
        }
        return false;
    }

    public int runningCount() {
        return this.getRunningInputs().size();
    }

    public MessageInput getRunningInput(String inputId) {
        for (IOState inputState : this) {
            if (!((MessageInput)inputState.getStoppable()).getId().equals(inputId)) continue;
            return (MessageInput)inputState.getStoppable();
        }
        return null;
    }

    public IOState<MessageInput> getRunningInputState(String inputStateId) {
        for (IOState inputState : this) {
            if (!((MessageInput)inputState.getStoppable()).getId().equals(inputStateId)) continue;
            return inputState;
        }
        return null;
    }

    public boolean remove(MessageInput input) {
        IOState<MessageInput> inputState = this.stop(input);
        input.terminate();
        if (inputState != null) {
            inputState.setState(IOState.Type.TERMINATED);
        }
        return super.remove(inputState);
    }

    public boolean remove(IOState<MessageInput> inputState) {
        MessageInput messageInput = inputState.getStoppable();
        return this.remove(messageInput);
    }

    public IOState<MessageInput> stop(MessageInput input) {
        IOState<MessageInput> inputState = this.getRunningInputState(input.getId());
        if (inputState != null) {
            inputState.setState(IOState.Type.STOPPING);
            try {
                input.stop();
            }
            catch (Exception e) {
                LOG.warn("Stopping input <{}> failed, removing anyway: {}", (Object)input.getId(), (Object)e);
            }
            inputState.setState(IOState.Type.STOPPED);
        }
        return inputState;
    }
}

