/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.cluster.jest;

import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.RequestLine;
import org.apache.http.StatusLine;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestResponseLogger
implements HttpResponseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(RequestResponseLogger.class);
    private final Logger logger;

    public RequestResponseLogger() {
        this(LOG);
    }

    public RequestResponseLogger(Logger logger) {
        this.logger = logger;
    }

    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        StatusLine statusLine = response.getStatusLine();
        HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
        HttpRequest httpRequest = (HttpRequest)context.getAttribute("http.request");
        RequestLine request = httpRequest.getRequestLine();
        this.logger.trace("[{} {}]: {} {}{}", new Object[]{statusLine.getStatusCode(), statusLine.getReasonPhrase(), request.getMethod(), targetHost.toURI(), request.getUri()});
    }
}

