/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.search;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ForbiddenException;
import org.glassfish.jersey.server.ChunkedOutput;
import org.graylog2.decorators.DecoratorProcessor;
import org.graylog2.indexer.FieldTypeException;
import org.graylog2.indexer.ranges.IndexRange;
import org.graylog2.indexer.results.FieldStatsResult;
import org.graylog2.indexer.results.ResultMessage;
import org.graylog2.indexer.results.ScrollResult;
import org.graylog2.indexer.results.SearchResult;
import org.graylog2.indexer.results.TermsStatsResult;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.indexer.searches.SearchesClusterConfig;
import org.graylog2.indexer.searches.Sorting;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.rest.models.messages.responses.ResultMessageSummary;
import org.graylog2.rest.models.search.responses.HistogramResult;
import org.graylog2.rest.models.search.responses.TermsResult;
import org.graylog2.rest.models.search.responses.TimeRange;
import org.graylog2.rest.models.system.indexer.responses.IndexRangeSummary;
import org.graylog2.rest.resources.search.responses.SearchResponse;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.shared.utilities.ExceptionUtils;
import org.graylog2.utilities.SearchUtils;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SearchResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(SearchResource.class);
    protected static final String DEFAULT_SCROLL_BATCH_SIZE = "500";
    protected final Searches searches;
    private final ClusterConfigService clusterConfigService;
    private final DecoratorProcessor decoratorProcessor;

    public SearchResource(Searches searches, ClusterConfigService clusterConfigService, DecoratorProcessor decoratorProcessor) {
        this.searches = searches;
        this.clusterConfigService = clusterConfigService;
        this.decoratorProcessor = decoratorProcessor;
    }

    protected void validateInterval(String interval) {
        if (!SearchUtils.validateInterval(interval)) {
            LOG.warn("Invalid interval type <{}>. Returning HTTP 400.", (Object)interval);
            throw new BadRequestException("Invalid interval type: " + interval + "\"");
        }
    }

    protected List<String> parseFields(String fields) {
        if (Strings.isNullOrEmpty((String)fields)) {
            LOG.warn("Missing fields parameter. Returning HTTP 400");
            throw new BadRequestException("Missing required parameter `fields`");
        }
        return this.parseOptionalFields(fields);
    }

    protected List<String> parseOptionalFields(String fields) {
        if (Strings.isNullOrEmpty((String)fields)) {
            return null;
        }
        Iterable split = Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)fields);
        ArrayList fieldList = Lists.newArrayList((Object[])new String[]{"timestamp"});
        for (String field : split) {
            if ("timestamp".equals(field)) continue;
            fieldList.add(field);
        }
        return fieldList;
    }

    protected FieldStatsResult fieldStats(String field, String query, String filter, org.graylog2.plugin.indexer.searches.timeranges.TimeRange timeRange) {
        try {
            return this.searches.fieldStats(field, query, filter, timeRange);
        }
        catch (FieldTypeException e) {
            try {
                LOG.debug("Stats query failed, make sure that field [{}] is a numeric type. Retrying without numeric statistics to calculate the field's cardinality.", (Object)field);
                return this.searches.fieldStats(field, query, filter, timeRange, true, false, true);
            }
            catch (FieldTypeException e1) {
                LOG.error("Retrieving field statistics for field {} failed while calculating the cardinality. Cause: {}", (Object)field, (Object)ExceptionUtils.getRootCauseMessage(e1));
                throw new BadRequestException("Field " + field + " is not of a numeric type and the cardinality could not be calculated either.", (Throwable)e1);
            }
        }
    }

    protected org.graylog2.indexer.results.HistogramResult fieldHistogram(String field, String query, String interval, String filter, org.graylog2.plugin.indexer.searches.timeranges.TimeRange timeRange, boolean includeCardinality) {
        try {
            return this.searches.fieldHistogram(query, field, Searches.DateHistogramInterval.valueOf(interval), filter, timeRange, true, includeCardinality);
        }
        catch (FieldTypeException e) {
            try {
                LOG.debug("Field histogram query failed. Make sure that field [{}] is a numeric type. Retrying without numerical statistics.", (Object)field);
                return this.searches.fieldHistogram(query, field, Searches.DateHistogramInterval.valueOf(interval), filter, timeRange, false, true);
            }
            catch (FieldTypeException e1) {
                String msg = "Field histogram for field [" + field + "] failed while calculating its cardinality.";
                LOG.error(msg, (Object)ExceptionUtils.getRootCauseMessage(e1));
                throw new BadRequestException(msg, (Throwable)e1);
            }
        }
    }

    protected TermsResult buildTermsResult(org.graylog2.indexer.results.TermsResult tr) {
        return TermsResult.create(tr.tookMs(), tr.getTerms(), tr.termsMapping(), tr.getMissing(), tr.getOther(), tr.getTotal(), tr.getBuiltQuery());
    }

    protected org.graylog2.rest.models.search.responses.TermsStatsResult buildTermsStatsResult(TermsStatsResult tr) {
        return org.graylog2.rest.models.search.responses.TermsStatsResult.create(tr.tookMs(), tr.getResults(), tr.getBuiltQuery());
    }

    protected SearchResponse buildSearchResponse(SearchResult sr, org.graylog2.plugin.indexer.searches.timeranges.TimeRange timeRange, boolean decorate, Optional<String> streamId) {
        SearchResponse result = SearchResponse.create(sr.getOriginalQuery(), sr.getBuiltQuery(), this.indexRangeListToValueList(sr.getUsedIndices()), this.resultMessageListtoValueList(sr.getResults()), sr.getFields(), sr.tookMs(), sr.getTotalResults(), timeRange.getFrom(), timeRange.getTo());
        return decorate ? this.decoratorProcessor.decorate(result, streamId) : result;
    }

    protected Set<IndexRangeSummary> indexRangeListToValueList(Set<IndexRange> indexRanges) {
        HashSet result = Sets.newHashSetWithExpectedSize((int)indexRanges.size());
        for (IndexRange indexRange : indexRanges) {
            result.add(IndexRangeSummary.create(indexRange.indexName(), indexRange.begin(), indexRange.end(), indexRange.calculatedAt(), indexRange.calculationDuration()));
        }
        return result;
    }

    protected List<ResultMessageSummary> resultMessageListtoValueList(List<ResultMessage> resultMessages) {
        return resultMessages.stream().map(resultMessage -> ResultMessageSummary.create(resultMessage.highlightRanges, resultMessage.getMessage().getFields(), resultMessage.getIndex())).collect(Collectors.toList());
    }

    protected org.graylog2.rest.models.search.responses.FieldStatsResult buildFieldStatsResult(FieldStatsResult sr) {
        return org.graylog2.rest.models.search.responses.FieldStatsResult.create(sr.tookMs(), sr.getCount(), sr.getSum(), sr.getSumOfSquares(), sr.getMean(), sr.getMin(), sr.getMax(), sr.getVariance(), sr.getStdDeviation(), sr.getBuiltQuery(), sr.getCardinality());
    }

    protected HistogramResult buildHistogramResult(org.graylog2.indexer.results.HistogramResult histogram) {
        AbsoluteRange histogramBoundaries = histogram.getHistogramBoundaries();
        return HistogramResult.create(histogram.getInterval().toString().toLowerCase(Locale.ENGLISH), histogram.getResults(), histogram.tookMs(), histogram.getBuiltQuery(), TimeRange.create(histogramBoundaries.getFrom(), histogramBoundaries.getTo()));
    }

    protected Sorting buildSorting(String sort) {
        if (Strings.isNullOrEmpty((String)sort)) {
            return Sorting.DEFAULT;
        }
        try {
            return Sorting.fromApiParam(sort);
        }
        catch (Exception e) {
            LOG.error("Falling back to default sorting.", (Throwable)e);
            return Sorting.DEFAULT;
        }
    }

    protected ChunkedOutput<ScrollResult.ScrollChunk> buildChunkedOutput(ScrollResult scroll, int limit) {
        ChunkedOutput output = new ChunkedOutput(ScrollResult.ScrollChunk.class);
        LOG.debug("[{}] Scroll result contains a total of {} messages", (Object)scroll.getQueryHash(), (Object)scroll.totalHits());
        Runnable scrollIterationAction = this.createScrollChunkProducer(scroll, (ChunkedOutput<ScrollResult.ScrollChunk>)output, limit);
        new Thread(scrollIterationAction).start();
        return output;
    }

    public void checkSearchPermission(String filter, String searchPermission) {
        if (Strings.isNullOrEmpty((String)filter) || "*".equals(filter)) {
            this.checkPermission(searchPermission);
        } else {
            if (!filter.startsWith("streams:")) {
                throw new ForbiddenException("Not allowed to search with filter: [" + filter + "]");
            }
            String[] parts = filter.split(":");
            if (parts.length <= 1) {
                throw new ForbiddenException("Not allowed to search with filter: [" + filter + "]");
            }
            String streamList = parts[1];
            String[] streams = streamList.split(",");
            if (streams.length == 0) {
                throw new ForbiddenException("Not allowed to search with filter: [" + filter + "]");
            }
            for (String streamId : streams) {
                if (this.isPermitted("streams:read", streamId)) continue;
                String msg = "Not allowed to search with filter: [" + filter + "]. (Forbidden stream: " + streamId + ")";
                LOG.warn(msg);
                throw new ForbiddenException(msg);
            }
        }
    }

    protected Runnable createScrollChunkProducer(final ScrollResult scroll, final ChunkedOutput<ScrollResult.ScrollChunk> output, final int limit) {
        return new Runnable(){
            private int collectedHits = 0;

            @Override
            public void run() {
                try {
                    ScrollResult.ScrollChunk chunk = scroll.nextChunk();
                    while (chunk != null) {
                        LOG.debug("[{}] Writing scroll chunk with {} messages", (Object)scroll.getQueryHash(), (Object)chunk.getMessages().size());
                        if (output.isClosed()) {
                            LOG.debug("[{}] Client connection is closed, client disconnected. Aborting scroll.", (Object)scroll.getQueryHash());
                            scroll.cancel();
                            return;
                        }
                        output.write((Object)chunk);
                        this.collectedHits += chunk.getMessages().size();
                        if (limit != 0 && this.collectedHits >= limit) {
                            scroll.cancel();
                            output.close();
                            return;
                        }
                        chunk = scroll.nextChunk();
                    }
                    LOG.debug("[{}] Reached end of scroll result.", (Object)scroll.getQueryHash());
                    output.close();
                }
                catch (IOException e) {
                    LOG.warn("[{}] Could not close chunked output stream for query scroll.", (Object)scroll.getQueryHash());
                }
            }
        };
    }

    protected org.graylog2.plugin.indexer.searches.timeranges.TimeRange restrictTimeRange(org.graylog2.plugin.indexer.searches.timeranges.TimeRange timeRange) {
        DateTime limitedFrom;
        DateTime originalFrom = timeRange.getFrom();
        DateTime to = timeRange.getTo();
        SearchesClusterConfig config = this.clusterConfigService.get(SearchesClusterConfig.class);
        DateTime from = config == null || Period.ZERO.equals((Object)config.queryTimeRangeLimit()) ? originalFrom : ((limitedFrom = to.minus((ReadablePeriod)config.queryTimeRangeLimit())).isAfter((ReadableInstant)originalFrom) ? limitedFrom : originalFrom);
        return AbsoluteRange.create(from, to);
    }

    protected List<String> splitStackedFields(String stackedFieldsParam) {
        if (stackedFieldsParam == null || stackedFieldsParam.isEmpty()) {
            return Collections.emptyList();
        }
        return Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)stackedFieldsParam);
    }
}

