/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.beats;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.graylog.plugins.beats.MapUtils;
import org.graylog2.jackson.TypeReferences;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.inputs.annotations.Codec;
import org.graylog2.plugin.inputs.annotations.ConfigClass;
import org.graylog2.plugin.inputs.annotations.FactoryClass;
import org.graylog2.plugin.inputs.codecs.AbstractCodec;
import org.graylog2.plugin.inputs.codecs.Codec;
import org.graylog2.plugin.journal.RawMessage;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Codec(name="beats-legacy", displayName="Beats Legacy")
public class BeatsCodec
extends AbstractCodec {
    private static final Logger LOG = LoggerFactory.getLogger(BeatsCodec.class);
    private static final String MAP_KEY_SEPARATOR = "_";
    private final ObjectMapper objectMapper;

    @Inject
    public BeatsCodec(@Assisted Configuration configuration, ObjectMapper objectMapper) {
        super(configuration);
        this.objectMapper = Objects.requireNonNull(objectMapper);
    }

    @Override
    @Nullable
    public Message decode(@Nonnull RawMessage rawMessage) {
        Map event;
        byte[] payload = rawMessage.getPayload();
        try {
            event = (Map)this.objectMapper.readValue(payload, TypeReferences.MAP_STRING_OBJECT);
        }
        catch (IOException e) {
            LOG.error("Couldn't decode raw message {}", (Object)rawMessage);
            return null;
        }
        return this.parseEvent(event);
    }

    @Nullable
    private Message parseEvent(Map<String, Object> event) {
        Message gelfMessage;
        String type;
        HashMap metadata = (HashMap)event.remove("@metadata");
        if (metadata == null) {
            LOG.warn("Couldn't recognize Beats type");
            type = "unknown";
        } else {
            type = (String)metadata.get("beat");
        }
        switch (type) {
            case "filebeat": {
                gelfMessage = this.parseFilebeat(event);
                break;
            }
            case "topbeat": {
                gelfMessage = this.parseTopbeat(event);
                break;
            }
            case "metricbeat": {
                gelfMessage = this.parseMetricbeat(event);
                break;
            }
            case "packetbeat": {
                gelfMessage = this.parsePacketbeat(event);
                break;
            }
            case "winlogbeat": {
                gelfMessage = this.parseWinlogbeat(event);
                break;
            }
            default: {
                LOG.debug("Unknown beats type {}. Using generic handler.", (Object)type);
                gelfMessage = this.parseGenericBeat(event);
            }
        }
        return gelfMessage;
    }

    private Message createMessage(String message, Map<String, Object> event) {
        String name;
        String hostname;
        Map beat = (Map)event.remove("beat");
        if (beat == null) {
            hostname = "unknown";
            name = "unknown";
        } else {
            hostname = String.valueOf(beat.get("hostname"));
            name = String.valueOf(beat.get("name"));
        }
        String timestampField = String.valueOf(event.remove("@timestamp"));
        DateTime timestamp = Tools.dateTimeFromString(timestampField);
        String type = String.valueOf(event.get("type"));
        Object tags = event.get("tags");
        Message result = new Message(message, hostname, timestamp);
        result.addField("name", name);
        result.addField("type", type);
        result.addField("tags", tags);
        Map fields = (Map)event.get("fields");
        if (fields != null) {
            result.addFields(fields);
        }
        return result;
    }

    private Message parseFilebeat(Map<String, Object> event) {
        String message = String.valueOf(event.get("message"));
        Message gelfMessage = this.createMessage(message, event);
        gelfMessage.addField("facility", "filebeat");
        gelfMessage.addField("file", event.get("source"));
        gelfMessage.addField("input_type", event.get("input_type"));
        gelfMessage.addField("count", event.get("count"));
        gelfMessage.addField("offset", event.get("offset"));
        return gelfMessage;
    }

    private Message parseTopbeat(Map<String, Object> event) {
        Message gelfMessage = this.createMessage("-", event);
        gelfMessage.addField("facility", "topbeat");
        Map<String, Object> flattened = MapUtils.flatten(event, "topbeat", MAP_KEY_SEPARATOR);
        Map<String, Object> withoutDots = MapUtils.replaceKeyCharacter(flattened, '.', MAP_KEY_SEPARATOR.charAt(0));
        gelfMessage.addFields(withoutDots);
        return gelfMessage;
    }

    private Message parseMetricbeat(Map<String, Object> event) {
        Message gelfMessage = this.createMessage("-", event);
        gelfMessage.addField("facility", "metricbeat");
        Map<String, Object> flattened = MapUtils.flatten(event, "metricbeat", MAP_KEY_SEPARATOR);
        Map<String, Object> withoutDots = MapUtils.replaceKeyCharacter(flattened, '.', MAP_KEY_SEPARATOR.charAt(0));
        gelfMessage.addFields(withoutDots);
        return gelfMessage;
    }

    private Message parsePacketbeat(Map<String, Object> event) {
        Message gelfMessage = this.createMessage("-", event);
        gelfMessage.addField("facility", "packetbeat");
        Map<String, Object> flattened = MapUtils.flatten(event, "packetbeat", MAP_KEY_SEPARATOR);
        Map<String, Object> withoutDots = MapUtils.replaceKeyCharacter(flattened, '.', MAP_KEY_SEPARATOR.charAt(0));
        gelfMessage.addFields(withoutDots);
        return gelfMessage;
    }

    private Message parseWinlogbeat(Map<String, Object> event) {
        String message = String.valueOf(event.remove("message"));
        Message gelfMessage = this.createMessage(message, event);
        gelfMessage.addField("facility", "winlogbeat");
        Map<String, Object> flattened = MapUtils.flatten(event, "winlogbeat", MAP_KEY_SEPARATOR);
        Map<String, Object> withoutDots = MapUtils.replaceKeyCharacter(flattened, '.', MAP_KEY_SEPARATOR.charAt(0));
        gelfMessage.addFields(withoutDots);
        return gelfMessage;
    }

    private Message parseGenericBeat(Map<String, Object> event) {
        String message = String.valueOf(event.remove("message"));
        Message gelfMessage = this.createMessage(message, event);
        gelfMessage.addField("facility", "genericbeat");
        Map<String, Object> flattened = MapUtils.flatten(event, "beat", MAP_KEY_SEPARATOR);
        Map<String, Object> withoutDots = MapUtils.replaceKeyCharacter(flattened, '.', MAP_KEY_SEPARATOR.charAt(0));
        gelfMessage.addFields(withoutDots);
        return gelfMessage;
    }

    public static class Descriptor
    extends AbstractCodec.Descriptor {
        @Inject
        public Descriptor() {
            super(BeatsCodec.class.getAnnotation(Codec.class).displayName());
        }
    }

    @ConfigClass
    public static class Config
    extends AbstractCodec.Config {
    }

    @FactoryClass
    public static interface Factory
    extends Codec.Factory<BeatsCodec> {
        @Override
        public BeatsCodec create(Configuration var1);

        @Override
        public Config getConfig();

        @Override
        public Descriptor getDescriptor();
    }
}

