/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.map.geoip;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.net.InetAddresses;
import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.record.City;
import com.maxmind.geoip2.record.Country;
import com.maxmind.geoip2.record.Location;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.graylog.plugins.map.config.GeoIpResolverConfig;
import org.graylog.plugins.map.geoip.AutoValue_GeoIpResolverEngine_GeoLocationInformation;
import org.graylog2.plugin.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoIpResolverEngine {
    private static final Logger LOG = LoggerFactory.getLogger(GeoIpResolverEngine.class);
    private static final String INTERNAL_FIELD_PREFIX = "gl2_";
    private final Timer resolveTime;
    private DatabaseReader databaseReader;
    private boolean enabled;

    public GeoIpResolverEngine(GeoIpResolverConfig config, MetricRegistry metricRegistry) {
        this.resolveTime = metricRegistry.timer(MetricRegistry.name(GeoIpResolverEngine.class, (String[])new String[]{"resolveTime"}));
        try {
            File database = new File(config.dbPath());
            if (Files.exists(database.toPath(), new LinkOption[0])) {
                this.databaseReader = new DatabaseReader.Builder(database).build();
                this.enabled = config.enabled();
            } else {
                LOG.warn("GeoIP database file does not exist: {}", (Object)config.dbPath());
                this.enabled = false;
            }
        }
        catch (IOException e) {
            LOG.error("Could not open GeoIP database {}", (Object)config.dbPath(), (Object)e);
            this.enabled = false;
        }
    }

    public boolean filter(Message message) {
        if (!this.enabled) {
            return false;
        }
        for (Map.Entry<String, Object> field : message.getFields().entrySet()) {
            String key = field.getKey();
            if (key.startsWith(INTERNAL_FIELD_PREFIX)) continue;
            Optional<GeoLocationInformation> geoLocationInformation = this.extractGeoLocationInformation(field.getValue());
            geoLocationInformation.ifPresent(locationInformation -> {
                message.addField(key + "_geolocation", locationInformation.latitude() + "," + locationInformation.longitude());
                message.addField(key + "_country_code", locationInformation.countryIsoCode());
                message.addField(key + "_city_name", locationInformation.cityName());
            });
        }
        return false;
    }

    @VisibleForTesting
    Optional<GeoLocationInformation> extractGeoLocationInformation(Object fieldValue) {
        InetAddress ipAddress = fieldValue instanceof InetAddress ? (InetAddress)fieldValue : (fieldValue instanceof String ? this.getIpFromFieldValue((String)fieldValue) : null);
        GeoLocationInformation geoLocationInformation = null;
        if (ipAddress != null) {
            try (Timer.Context ignored = this.resolveTime.time();){
                CityResponse response = this.databaseReader.city(ipAddress);
                Location location = response.getLocation();
                Country country = response.getCountry();
                City city = response.getCity();
                geoLocationInformation = GeoLocationInformation.create(location.getLatitude(), location.getLongitude(), country.getGeoNameId() != null ? country.getIsoCode() : "N/A", city.getGeoNameId() != null ? city.getName() : "N/A");
            }
            catch (Exception e) {
                LOG.debug("Could not get location from IP {}", (Object)ipAddress.getHostAddress(), (Object)e);
            }
        }
        return Optional.ofNullable(geoLocationInformation);
    }

    @Nullable
    @VisibleForTesting
    InetAddress getIpFromFieldValue(String fieldValue) {
        try {
            return InetAddresses.forString((String)fieldValue.trim());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @AutoValue
    static abstract class GeoLocationInformation {
        GeoLocationInformation() {
        }

        public abstract double latitude();

        public abstract double longitude();

        public abstract String countryIsoCode();

        public abstract String cityName();

        public static GeoLocationInformation create(double latitude, double longitude, String countryIsoCode, String cityName) {
            return new AutoValue_GeoIpResolverEngine_GeoLocationInformation(latitude, longitude, countryIsoCode, cityName);
        }
    }
}

