/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.map.search;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.graylog.plugins.map.search.MapDataSearchRequest;
import org.graylog.plugins.map.search.MapDataSearchResult;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.rest.models.search.responses.TermsResult;

public class MapDataSearch {
    private static final Pattern VALIDATION_PATTERN = Pattern.compile("^-?\\d+\\.\\d+$");
    private final Searches searches;

    @Inject
    public MapDataSearch(Searches searches) {
        this.searches = searches;
    }

    public MapDataSearchResult searchMapData(MapDataSearchRequest request) throws ValueTypeException {
        ImmutableMap.Builder termResults = ImmutableMap.builder();
        String filter = null;
        if (!Strings.isNullOrEmpty((String)request.streamId())) {
            filter = "streams:" + request.streamId();
        }
        for (String field : request.fields()) {
            org.graylog2.indexer.results.TermsResult terms = this.searches.terms(field, request.limit(), request.query(), filter, request.timerange());
            Map<String, Long> validatedTerms = this.validateTerms(field, terms.getTerms());
            TermsResult result = TermsResult.create(terms.tookMs(), validatedTerms, terms.getMissing(), terms.getOther(), terms.getTotal(), terms.getBuiltQuery());
            termResults.put((Object)field, (Object)result);
        }
        return MapDataSearchResult.builder().query(request.query()).timerange(request.timerange()).limit(request.limit()).streamId(request.streamId()).fields((Map<String, TermsResult>)termResults.build()).build();
    }

    private Map<String, Long> validateTerms(String field, Map<String, Long> terms) throws ValueTypeException {
        Splitter splitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
        for (String term : terms.keySet()) {
            if (Strings.isNullOrEmpty((String)term)) continue;
            List list = splitter.splitToList((CharSequence)term);
            if (list.size() != 2) {
                throw this.getValueTypeException(field, term);
            }
            for (String value : list) {
                if (VALIDATION_PATTERN.matcher(value).matches()) continue;
                throw this.getValueTypeException(field, term);
            }
        }
        return terms;
    }

    private ValueTypeException getValueTypeException(String field, String term) {
        return new ValueTypeException("Invalid geo data term for field \"" + field + "\": " + term + " (required: <lat>,<lng> - example: 1.23,3.11)");
    }

    public static class ValueTypeException
    extends Exception {
        public ValueTypeException(String message) {
            super(message);
        }
    }
}

