/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.ast.functions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.expressions.Expression;
import org.graylog.plugins.pipelineprocessor.ast.functions.AutoValue_ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;

@JsonAutoDetect
@AutoValue
public abstract class ParameterDescriptor<T, R> {
    @JsonProperty
    public abstract Class<? extends T> type();

    @JsonProperty
    public abstract Class<? extends R> transformedType();

    @JsonProperty
    public abstract String name();

    @JsonProperty
    public abstract boolean optional();

    @JsonIgnore
    public abstract Function<T, R> transform();

    @JsonProperty
    @Nullable
    public abstract String description();

    public static <T, R> Builder<T, R> param() {
        return new AutoValue_ParameterDescriptor.Builder().optional(false);
    }

    public static Builder<String, String> string(String name) {
        return ParameterDescriptor.string(name, String.class);
    }

    public static <R> Builder<String, R> string(String name, Class<? extends R> transformedClass) {
        return ParameterDescriptor.param().type(String.class).transformedType(transformedClass).name(name);
    }

    public static Builder<Object, Object> object(String name) {
        return ParameterDescriptor.object(name, Object.class);
    }

    public static <R> Builder<Object, R> object(String name, Class<? extends R> transformedClass) {
        return ParameterDescriptor.param().type(Object.class).transformedType(transformedClass).name(name);
    }

    public static Builder<Long, Long> integer(String name) {
        return ParameterDescriptor.integer(name, Long.class);
    }

    public static <R> Builder<Long, R> integer(String name, Class<? extends R> transformedClass) {
        return ParameterDescriptor.param().type(Long.class).transformedType(transformedClass).name(name);
    }

    public static Builder<Double, Double> floating(String name) {
        return ParameterDescriptor.floating(name, Double.class);
    }

    public static <R> Builder<Double, R> floating(String name, Class<? extends R> transformedClass) {
        return ParameterDescriptor.param().type(Double.class).transformedType(transformedClass).name(name);
    }

    public static Builder<Boolean, Boolean> bool(String name) {
        return ParameterDescriptor.bool(name, Boolean.class);
    }

    public static <R> Builder<Boolean, R> bool(String name, Class<? extends R> transformedClass) {
        return ParameterDescriptor.param().type(Boolean.class).transformedType(transformedClass).name(name);
    }

    public static <T> Builder<T, T> type(String name, Class<? extends T> typeClass) {
        return ParameterDescriptor.type(name, typeClass, typeClass);
    }

    public static <T, R> Builder<T, R> type(String name, Class<? extends T> typeClass, Class<? extends R> transformedClass) {
        return ParameterDescriptor.param().type(typeClass).transformedType(transformedClass).name(name);
    }

    @Nullable
    public R required(FunctionArgs args, EvaluationContext context) {
        Object precomputedValue = args.getPreComputedValue(this.name());
        if (precomputedValue != null) {
            return this.transformedType().cast(precomputedValue);
        }
        Expression valueExpr = args.expression(this.name());
        if (valueExpr == null) {
            return null;
        }
        Object value = valueExpr.evaluateUnsafe(context);
        return this.transformedType().cast(this.transform().apply(this.type().cast(value)));
    }

    public Optional<R> optional(FunctionArgs args, EvaluationContext context) {
        return Optional.ofNullable(this.required(args, context));
    }

    @AutoValue.Builder
    public static abstract class Builder<T, R> {
        public abstract Builder<T, R> type(Class<? extends T> var1);

        public abstract Builder<T, R> transformedType(Class<? extends R> var1);

        public abstract Builder<T, R> name(String var1);

        public abstract Builder<T, R> optional(boolean var1);

        public Builder<T, R> optional() {
            return this.optional(true);
        }

        public abstract Builder<T, R> description(String var1);

        abstract ParameterDescriptor<T, R> autoBuild();

        public ParameterDescriptor<T, R> build() {
            try {
                this.transform();
            }
            catch (IllegalStateException ignored) {
                this.transform(Function.identity());
            }
            return this.autoBuild();
        }

        public abstract Builder<T, R> transform(@Nullable Function<T, R> var1);

        @Nullable
        public abstract Function<T, R> transform();
    }
}

