/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.codegen.compiler;

import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import java.util.stream.Collectors;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.validation.constraints.NotNull;

public class InMemoryFileManager
extends ForwardingJavaFileManager<StandardJavaFileManager> {
    private final Map<String, ByteArrayOutputStream> classBytes = Maps.newLinkedHashMap();

    public InMemoryFileManager(StandardJavaFileManager fileManager) {
        super(fileManager);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        if (location == StandardLocation.CLASS_OUTPUT && this.classBytes.containsKey(className) && kind == JavaFileObject.Kind.CLASS) {
            final byte[] bytes = this.classBytes.get(className).toByteArray();
            return new SimpleJavaFileObject(URI.create(className), kind){

                @Override
                @NotNull
                public InputStream openInputStream() {
                    return new ByteArrayInputStream(bytes);
                }
            };
        }
        return ((StandardJavaFileManager)this.fileManager).getJavaFileForInput(location, className, kind);
    }

    @Override
    @NotNull
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, final String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        return new SimpleJavaFileObject(URI.create(className), kind){

            @Override
            @NotNull
            public OutputStream openOutputStream() {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                InMemoryFileManager.this.classBytes.put(className, stream);
                return stream;
            }
        };
    }

    @NotNull
    public Map<String, byte[]> getAllClassBytes() {
        return this.classBytes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ByteArrayOutputStream)e.getValue()).toByteArray()));
    }
}

