/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.db.mongodb;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import org.graylog.plugins.pipelineprocessor.db.PipelineStreamConnectionsService;
import org.graylog.plugins.pipelineprocessor.events.PipelineConnectionsChangedEvent;
import org.graylog.plugins.pipelineprocessor.rest.PipelineConnections;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.graylog2.events.ClusterEventBus;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbPipelineStreamConnectionsService
implements PipelineStreamConnectionsService {
    private static final Logger log = LoggerFactory.getLogger(MongoDbPipelineStreamConnectionsService.class);
    private static final String COLLECTION = "pipeline_processor_pipelines_streams";
    private final JacksonDBCollection<PipelineConnections, String> dbCollection;
    private final ClusterEventBus clusterBus;

    @Inject
    public MongoDbPipelineStreamConnectionsService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, ClusterEventBus clusterBus) {
        this.dbCollection = JacksonDBCollection.wrap((DBCollection)mongoConnection.getDatabase().getCollection(COLLECTION), PipelineConnections.class, String.class, (ObjectMapper)mapper.get());
        this.clusterBus = clusterBus;
        this.dbCollection.createIndex((DBObject)DBSort.asc((String)"stream_id"), (DBObject)new BasicDBObject("unique", (Object)true));
    }

    @Override
    public PipelineConnections save(PipelineConnections connections) {
        PipelineConnections existingConnections = (PipelineConnections)this.dbCollection.findOne(DBQuery.is((String)"stream_id", (Object)connections.streamId()));
        if (existingConnections == null) {
            existingConnections = PipelineConnections.create(null, connections.streamId(), Collections.emptySet());
        }
        PipelineConnections toSave = existingConnections.toBuilder().pipelineIds(connections.pipelineIds()).build();
        WriteResult save = this.dbCollection.save((Object)toSave);
        PipelineConnections savedConnections = (PipelineConnections)save.getSavedObject();
        this.clusterBus.post(PipelineConnectionsChangedEvent.create(savedConnections.streamId(), savedConnections.pipelineIds()));
        return savedConnections;
    }

    @Override
    public PipelineConnections load(String streamId) throws NotFoundException {
        PipelineConnections oneById = (PipelineConnections)this.dbCollection.findOne(DBQuery.is((String)"stream_id", (Object)streamId));
        if (oneById == null) {
            throw new NotFoundException("No pipeline connections with for stream " + streamId);
        }
        return oneById;
    }

    @Override
    public Set<PipelineConnections> loadAll() {
        ImmutableSet immutableSet;
        block8: {
            DBCursor connections = this.dbCollection.find();
            Throwable throwable = null;
            try {
                immutableSet = ImmutableSet.copyOf((Iterable)connections);
                if (connections == null) break block8;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (connections != null) {
                            MongoDbPipelineStreamConnectionsService.$closeResource(throwable, (AutoCloseable)connections);
                        }
                        throw throwable3;
                    }
                }
                catch (MongoException e) {
                    log.error("Unable to load pipeline connections", (Throwable)e);
                    return Collections.emptySet();
                }
            }
            MongoDbPipelineStreamConnectionsService.$closeResource(throwable, (AutoCloseable)connections);
        }
        return immutableSet;
    }

    @Override
    public Set<PipelineConnections> loadByPipelineId(String pipelineId) {
        ImmutableSet immutableSet;
        block8: {
            BasicDBObject query = new BasicDBObject("pipeline_ids", (Object)new BasicDBObject("$in", Collections.singleton(pipelineId)));
            DBCursor pipelineConnections = this.dbCollection.find((DBObject)query);
            Throwable throwable = null;
            try {
                immutableSet = ImmutableSet.copyOf((Iterable)pipelineConnections);
                if (pipelineConnections == null) break block8;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (pipelineConnections != null) {
                            MongoDbPipelineStreamConnectionsService.$closeResource(throwable, (AutoCloseable)pipelineConnections);
                        }
                        throw throwable3;
                    }
                }
                catch (MongoException e) {
                    log.error("Unable to load pipeline connections for pipeline ID " + pipelineId, (Throwable)e);
                    return Collections.emptySet();
                }
            }
            MongoDbPipelineStreamConnectionsService.$closeResource(throwable, (AutoCloseable)pipelineConnections);
        }
        return immutableSet;
    }

    @Override
    public void delete(String streamId) {
        try {
            PipelineConnections connections = this.load(streamId);
            Set<String> pipelineIds = connections.pipelineIds();
            this.dbCollection.removeById((Object)connections.id());
            this.clusterBus.post(PipelineConnectionsChangedEvent.create(streamId, pipelineIds));
        }
        catch (NotFoundException e) {
            log.debug("No connections found for stream " + streamId);
        }
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

