/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.ips;

import com.google.common.collect.ImmutableList;
import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.util.IllegalFormatException;
import java.util.Optional;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.functions.ips.IpAddress;

public class IpAddressConversion
extends AbstractFunction<IpAddress> {
    public static final String NAME = "to_ip";
    private static final InetAddress ANYV4 = InetAddresses.forString((String)"0.0.0.0");
    private final ParameterDescriptor<Object, Object> ipParam = ParameterDescriptor.object("ip").description("Value to convert").build();
    private final ParameterDescriptor<String, String> defaultParam = ParameterDescriptor.string("default").optional().description("Used when 'ip' is null or malformed, defaults to '0.0.0.0'").build();

    @Override
    public IpAddress evaluate(FunctionArgs args, EvaluationContext context) {
        String ipString = String.valueOf(this.ipParam.required(args, context));
        try {
            InetAddress inetAddress = InetAddresses.forString((String)ipString);
            return new IpAddress(inetAddress);
        }
        catch (IllegalArgumentException e) {
            Optional<String> defaultValue = this.defaultParam.optional(args, context);
            if (!defaultValue.isPresent()) {
                return new IpAddress(ANYV4);
            }
            try {
                return new IpAddress(InetAddresses.forString((String)defaultValue.get()));
            }
            catch (IllegalFormatException e1) {
                log.warn("Parameter `default` for to_ip() is not a valid IP address: {}", (Object)defaultValue.get());
                throw e1;
            }
        }
    }

    @Override
    public FunctionDescriptor<IpAddress> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(IpAddress.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.ipParam, this.defaultParam)).description("Converts a value to an IPAddress using its string representation").build();
    }
}

