/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import javax.inject.Inject;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonParse
extends AbstractFunction<JsonNode> {
    private static final Logger log = LoggerFactory.getLogger(JsonParse.class);
    public static final String NAME = "parse_json";
    private final ObjectMapper objectMapper;
    private final ParameterDescriptor<String, String> valueParam;

    @Inject
    public JsonParse(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.valueParam = ParameterDescriptor.string("value").description("The string to parse as a JSON tree").build();
    }

    @Override
    public JsonNode evaluate(FunctionArgs args, EvaluationContext context) {
        String value = this.valueParam.required(args, context);
        try {
            return this.objectMapper.readTree(value);
        }
        catch (IOException e) {
            log.warn("Unable to parse JSON", (Throwable)e);
            return MissingNode.getInstance();
        }
    }

    @Override
    public FunctionDescriptor<JsonNode> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(JsonNode.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.valueParam)).description("Parses a string as a JSON tree").build();
    }
}

