/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.messages;

import com.google.common.collect.ImmutableList;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog2.plugin.Message;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloneMessage
extends AbstractFunction<Message> {
    private static final Logger LOG = LoggerFactory.getLogger(CloneMessage.class);
    public static final String NAME = "clone_message";
    private final ParameterDescriptor<Message, Message> messageParam = ParameterDescriptor.type("message", Message.class).optional().description("The message to use, defaults to '$message'").build();

    @Override
    public Message evaluate(FunctionArgs args, EvaluationContext context) {
        Message clonedMessage;
        Message currentMessage = this.messageParam.optional(args, context).orElse(context.currentMessage());
        Object tsField = currentMessage.getField("timestamp");
        if (tsField instanceof DateTime) {
            clonedMessage = new Message(currentMessage.getMessage(), currentMessage.getSource(), currentMessage.getTimestamp());
            clonedMessage.addFields(currentMessage.getFields());
        } else {
            LOG.warn("Invalid timestamp <{}> (type: {}) in message <{}>. Using current time instead.", new Object[]{tsField, tsField.getClass().getCanonicalName(), currentMessage.getId()});
            DateTime now = DateTime.now((DateTimeZone)DateTimeZone.UTC);
            clonedMessage = new Message(currentMessage.getMessage(), currentMessage.getSource(), now);
            clonedMessage.addFields(currentMessage.getFields());
            clonedMessage.addField("timestamp", now);
            clonedMessage.addField("gl2_original_timestamp", String.valueOf(tsField));
        }
        clonedMessage.addStreams(currentMessage.getStreams());
        context.addCreatedMessage(clonedMessage);
        return clonedMessage;
    }

    @Override
    public FunctionDescriptor<Message> descriptor() {
        return FunctionDescriptor.builder().name(NAME).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.messageParam)).returnType(Message.class).description("Clones a message").build();
    }
}

