/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.messages;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import javax.inject.Provider;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.functions.messages.StreamCacheService;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.streams.DefaultStream;
import org.graylog2.plugin.streams.Stream;

public class RouteToStream
extends AbstractFunction<Void> {
    public static final String NAME = "route_to_stream";
    private static final String ID_ARG = "id";
    private static final String NAME_ARG = "name";
    private static final String REMOVE_FROM_DEFAULT = "remove_from_default";
    private final StreamCacheService streamCacheService;
    private final Provider<Stream> defaultStreamProvider;
    private final ParameterDescriptor<Message, Message> messageParam;
    private final ParameterDescriptor<String, String> nameParam;
    private final ParameterDescriptor<String, String> idParam;
    private final ParameterDescriptor<Boolean, Boolean> removeFromDefault;

    @Inject
    public RouteToStream(StreamCacheService streamCacheService, @DefaultStream Provider<Stream> defaultStreamProvider) {
        this.streamCacheService = streamCacheService;
        this.defaultStreamProvider = defaultStreamProvider;
        this.messageParam = ParameterDescriptor.type("message", Message.class).optional().description("The message to use, defaults to '$message'").build();
        this.nameParam = ParameterDescriptor.string(NAME_ARG).optional().description("The name of the stream to route the message to, must match exactly").build();
        this.idParam = ParameterDescriptor.string(ID_ARG).optional().description("The ID of the stream").build();
        this.removeFromDefault = ParameterDescriptor.bool(REMOVE_FROM_DEFAULT).optional().description("After routing the message, remove it from the default stream").build();
    }

    @Override
    public Void evaluate(FunctionArgs args, EvaluationContext context) {
        Collection<Stream> streams;
        String id = this.idParam.optional(args, context).orElse("");
        if ("".equals(id)) {
            String name = this.nameParam.optional(args, context).orElse("");
            if ("".equals(name)) {
                return null;
            }
            streams = this.streamCacheService.getByName(name);
            if (streams.isEmpty()) {
                return null;
            }
        } else {
            Stream stream2 = this.streamCacheService.getById(id);
            if (stream2 == null) {
                return null;
            }
            streams = Collections.singleton(stream2);
        }
        Message message = this.messageParam.optional(args, context).orElse(context.currentMessage());
        streams.forEach(stream -> {
            if (!stream.isPaused().booleanValue()) {
                message.addStream((Stream)stream);
            }
        });
        if (this.removeFromDefault.optional(args, context).orElse(Boolean.FALSE).booleanValue()) {
            message.removeStream((Stream)this.defaultStreamProvider.get());
        }
        return null;
    }

    @Override
    public FunctionDescriptor<Void> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(Void.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.nameParam, this.idParam, this.messageParam, this.removeFromDefault)).description("Routes a message to a stream").build();
    }
}

