/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.strings;

import com.google.common.collect.ImmutableList;
import org.apache.commons.lang3.StringUtils;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;

public class EndsWith
extends AbstractFunction<Boolean> {
    public static final String NAME = "ends_with";
    private final ParameterDescriptor<String, String> valueParam = ParameterDescriptor.string("value").description("The string to check").build();
    private final ParameterDescriptor<String, String> suffixParam = ParameterDescriptor.string("suffix").description("The suffix to check").build();
    private final ParameterDescriptor<Boolean, Boolean> ignoreCaseParam = ParameterDescriptor.bool("ignore_case").optional().description("Whether to search case insensitive, defaults to false").build();

    @Override
    public Boolean evaluate(FunctionArgs args, EvaluationContext context) {
        String value = this.valueParam.required(args, context);
        String suffix = this.suffixParam.required(args, context);
        boolean ignoreCase = this.ignoreCaseParam.optional(args, context).orElse(false);
        if (ignoreCase) {
            return StringUtils.endsWithIgnoreCase((CharSequence)value, (CharSequence)suffix);
        }
        return StringUtils.endsWith((CharSequence)value, (CharSequence)suffix);
    }

    @Override
    public FunctionDescriptor<Boolean> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(Boolean.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.valueParam, this.suffixParam, this.ignoreCaseParam)).description("Checks if a string ends with a suffix").build();
    }
}

