/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.urls;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.HttpUrl;

public class URL {
    private final HttpUrl url;
    private Map<String, String> queryMap;

    public URL(java.net.URL url) {
        this.url = HttpUrl.get((java.net.URL)url);
    }

    public URL(URI uri) {
        this.url = HttpUrl.get((URI)uri);
    }

    public URL(String urlString) {
        this.url = HttpUrl.parse((String)urlString);
    }

    public String getQuery() {
        return this.url.encodedQuery();
    }

    public Map<String, String> getQueryParams() {
        if (this.queryMap == null) {
            HashMap queryMap = Maps.newHashMapWithExpectedSize((int)this.url.querySize());
            for (String name : this.url.queryParameterNames()) {
                List values = this.url.queryParameterValues(name);
                String valueString = Joiner.on((char)',').join((Iterable)values);
                queryMap.put(name, valueString);
            }
            this.queryMap = queryMap;
        }
        return this.queryMap;
    }

    public String getUserInfo() {
        String username = this.url.encodedUsername();
        return username.isEmpty() ? "" : username + ':' + this.url.encodedPassword();
    }

    public String getHost() {
        return this.url.host();
    }

    public String getPath() {
        return this.url.encodedPath();
    }

    public String getFile() {
        return this.url.querySize() == 0 ? this.url.encodedPath() : this.url.encodedPath() + '?' + this.url.encodedQuery();
    }

    public String getProtocol() {
        return this.url.scheme();
    }

    public int getDefaultPort() {
        return this.url.port();
    }

    public String getFragment() {
        return this.url.encodedFragment();
    }

    public String getRef() {
        return this.getFragment();
    }

    public String getAuthority() {
        String userInfo = this.getUserInfo();
        return userInfo.isEmpty() ? this.getHost() + ':' + this.getPort() : this.getUserInfo() + '@' + this.getHost() + ':' + this.getPort();
    }

    public int getPort() {
        return this.url.port();
    }

    public boolean equals(Object obj) {
        return this.url.equals(obj);
    }

    public int hashCode() {
        return this.url.hashCode();
    }
}

