/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.sidecar.migrations;

import java.time.ZonedDateTime;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.graylog.plugins.sidecar.rest.models.Collector;
import org.graylog.plugins.sidecar.services.CollectorService;
import org.graylog2.migrations.Migration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20180212165000_AddDefaultCollectors
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20180212165000_AddDefaultCollectors.class);
    private final CollectorService collectorService;

    @Inject
    public V20180212165000_AddDefaultCollectors(CollectorService collectorService) {
        this.collectorService = collectorService;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2018-02-12T16:50:00Z");
    }

    @Override
    public void upgrade() {
        this.ensureCollector("filebeat", "exec", "linux", "/usr/bin/filebeat", "/etc/graylog/collector-sidecar/generated/filebeat.yml", "-c  %s", "test config -c %s", "");
        this.ensureCollector("winlogbeat", "svc", "windows", "C:\\Program Files\\graylog\\collector-sidecar\\winlogbeat.exe", "C:\\Program Files\\graylog\\collector-sidecar\\generated\\winlogbeat.yml", "-c %s", "test config -c %s", "");
        this.ensureCollector("nxlog", "exec", "linux", "/usr/bin/nxlog", "/etc/graylog/collector-sidecar/generated/nxlog.conf", "-f -c %s", "-v -c %s", "");
    }

    @Nullable
    private String ensureCollector(String collectorName, String serviceType, String nodeOperatingSystem, String executablePath, String configurationPath, String executeParameters, String validationCommand, String defaultTemplate) {
        Collector collector = null;
        try {
            collector = this.collectorService.findByName(collectorName);
            if (collector == null) {
                String msg = "Couldn't find collector '" + collectorName + "' fixing it.";
                LOG.error(msg);
                throw new IllegalArgumentException(msg);
            }
        }
        catch (IllegalArgumentException ignored) {
            LOG.info("{} collector is missing, adding it.", (Object)collectorName);
            Collector newCollector = Collector.create(null, collectorName, serviceType, nodeOperatingSystem, executablePath, configurationPath, executeParameters, validationCommand, defaultTemplate);
            try {
                return this.collectorService.save(newCollector).id();
            }
            catch (Exception e) {
                LOG.error("Can't save collector " + collectorName + ", please restart Graylog to fix this.", (Throwable)e);
            }
        }
        if (collector == null) {
            LOG.error("Unable to access fixed " + collectorName + " collector, please restart Graylog to fix this.");
            return null;
        }
        return collector.id();
    }
}

