/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.sidecar.rest.resources;

import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hashing;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.plugins.sidecar.rest.models.Collector;
import org.graylog.plugins.sidecar.rest.models.CollectorSummary;
import org.graylog.plugins.sidecar.rest.responses.CollectorListResponse;
import org.graylog.plugins.sidecar.rest.responses.CollectorSummaryResponse;
import org.graylog.plugins.sidecar.rest.responses.ValidationResponse;
import org.graylog.plugins.sidecar.services.CollectorService;
import org.graylog.plugins.sidecar.services.ConfigurationService;
import org.graylog.plugins.sidecar.services.EtagService;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.database.PaginatedList;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.search.SearchQuery;
import org.graylog2.search.SearchQueryField;
import org.graylog2.search.SearchQueryParser;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="Sidecar/Collectors", description="Manage collectors")
@Path(value="/sidecar/collectors")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@RequiresAuthentication
public class CollectorResource
extends RestResource
implements PluginRestResource {
    private final CollectorService collectorService;
    private final ConfigurationService configurationService;
    private final EtagService etagService;
    private final SearchQueryParser searchQueryParser;
    private static final ImmutableMap<String, SearchQueryField> SEARCH_FIELD_MAPPING = ImmutableMap.builder().put((Object)"id", (Object)SearchQueryField.create("id")).put((Object)"name", (Object)SearchQueryField.create("name")).put((Object)"operating_system", (Object)SearchQueryField.create("node_operating_system")).build();

    @Inject
    public CollectorResource(CollectorService collectorService, ConfigurationService configurationService, EtagService etagService) {
        this.collectorService = collectorService;
        this.configurationService = configurationService;
        this.etagService = etagService;
        this.searchQueryParser = new SearchQueryParser("name", (Map<String, SearchQueryField>)SEARCH_FIELD_MAPPING);
    }

    @GET
    @Path(value="/{id}")
    @RequiresPermissions(value={"sidecars:read"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Show collector details")
    public Collector getCollector(@ApiParam(name="id", required=true) @PathParam(value="id") String id) {
        return this.collectorService.find(id);
    }

    @GET
    @RequiresPermissions(value={"sidecars:read"})
    @Produces(value={"application/json"})
    @ApiOperation(value="List all collectors")
    public Response listCollectors(@Context HttpHeaders httpHeaders) {
        EntityTag etag;
        String ifNoneMatch = httpHeaders.getHeaderString("If-None-Match");
        Boolean etagCached = false;
        Response.ResponseBuilder builder = Response.noContent();
        if (ifNoneMatch != null && this.etagService.isPresent((etag = new EntityTag(ifNoneMatch.replaceAll("\"", ""))).toString())) {
            etagCached = true;
            builder = Response.notModified();
            builder.tag(etag);
        }
        if (!etagCached.booleanValue()) {
            List<Collector> result = this.collectorService.all();
            CollectorListResponse collectorListResponse = CollectorListResponse.create(result.size(), result);
            String etagString = this.collectorsToEtag(collectorListResponse);
            EntityTag collectorsEtag = new EntityTag(etagString);
            builder = Response.ok((Object)collectorListResponse);
            builder.tag(collectorsEtag);
            this.etagService.put(collectorsEtag.toString());
        }
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoTransform(true);
        cacheControl.setPrivate(true);
        builder.cacheControl(cacheControl);
        return builder.build();
    }

    @GET
    @Path(value="/summary")
    @RequiresPermissions(value={"sidecars:read"})
    @Produces(value={"application/json"})
    @ApiOperation(value="List a summary of all collectors")
    public CollectorSummaryResponse listSummary(@ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="50") int perPage, @ApiParam(name="query") @QueryParam(value="query") @DefaultValue(value="") String query, @ApiParam(name="sort", value="The field to sort the result on", required=true, allowableValues="name,id,collector_id") @DefaultValue(value="name") @QueryParam(value="sort") String sort, @ApiParam(name="order", value="The sort direction", allowableValues="asc, desc") @DefaultValue(value="asc") @QueryParam(value="order") String order) {
        SearchQuery searchQuery = this.searchQueryParser.parse(query);
        PaginatedList<Collector> collectors = this.collectorService.findPaginated(searchQuery, page, perPage, sort, order);
        long total = this.collectorService.count();
        List<CollectorSummary> summaries = collectors.stream().map(CollectorSummary::create).collect(Collectors.toList());
        return CollectorSummaryResponse.create(query, collectors.pagination(), total, sort, order, summaries);
    }

    @POST
    @RequiresPermissions(value={"sidecars:create"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a new collector")
    @AuditEvent(type="sidecar:collector:create")
    public Collector createCollector(@ApiParam(name="JSON body", required=true) @Valid @NotNull Collector request) {
        this.etagService.invalidateAll();
        Collector collector = this.collectorService.fromRequest(request);
        return this.collectorService.save(collector);
    }

    @PUT
    @Path(value="/{id}")
    @RequiresPermissions(value={"sidecars:update"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update a collector")
    @AuditEvent(type="sidecar:collector:update")
    public Collector updateCollector(@ApiParam(name="id", required=true) @PathParam(value="id") String id, @ApiParam(name="JSON body", required=true) @Valid @NotNull Collector request) {
        this.etagService.invalidateAll();
        Collector collector = this.collectorService.fromRequest(id, request);
        return this.collectorService.save(collector);
    }

    @POST
    @Path(value="/{id}/{name}")
    @RequiresPermissions(value={"sidecars:create"})
    @ApiOperation(value="Copy a collector")
    @AuditEvent(type="sidecar:collector:clone")
    public Response copyCollector(@ApiParam(name="id", required=true) @PathParam(value="id") String id, @PathParam(value="name") String name) throws NotFoundException {
        this.etagService.invalidateAll();
        Collector collector = this.collectorService.copy(id, name);
        this.collectorService.save(collector);
        return Response.accepted().build();
    }

    @DELETE
    @Path(value="/{id}")
    @RequiresPermissions(value={"sidecars:delete"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete a collector")
    @AuditEvent(type="sidecar:collector:delete")
    public Response deleteCollector(@ApiParam(name="id", required=true) @PathParam(value="id") String id) {
        long configurationsForCollector = this.configurationService.all().stream().filter(configuration -> configuration.collectorId().equals(id)).count();
        if (configurationsForCollector > 0L) {
            throw new BadRequestException("Collector still in use, cannot delete.");
        }
        int deleted = this.collectorService.delete(id);
        if (deleted == 0) {
            return Response.notModified().build();
        }
        this.etagService.invalidateAll();
        return Response.accepted().build();
    }

    @GET
    @Path(value="/validate")
    @RequiresPermissions(value={"configurations:read"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Validates collector name")
    public ValidationResponse validateCollector(@ApiParam(name="name", required=true) @QueryParam(value="name") String name) {
        Collector collector = this.collectorService.findByName(name);
        if (collector == null) {
            return ValidationResponse.create(false, null);
        }
        return ValidationResponse.create(true, "Collector with name \"" + name + "\" already exists");
    }

    private String collectorsToEtag(CollectorListResponse collectors) {
        return Hashing.md5().hashInt(collectors.hashCode()).toString();
    }
}

