/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.sidecar.services;

import com.google.common.collect.ImmutableSet;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.validation.Validator;
import org.graylog.plugins.sidecar.rest.models.Collector;
import org.graylog.plugins.sidecar.rest.models.CollectorStatus;
import org.graylog.plugins.sidecar.rest.models.CollectorStatusList;
import org.graylog.plugins.sidecar.rest.models.Configuration;
import org.graylog.plugins.sidecar.rest.models.NodeDetails;
import org.graylog.plugins.sidecar.rest.models.Sidecar;
import org.graylog.plugins.sidecar.rest.models.SidecarSummary;
import org.graylog.plugins.sidecar.rest.requests.ConfigurationAssignment;
import org.graylog.plugins.sidecar.rest.requests.RegistrationRequest;
import org.graylog.plugins.sidecar.services.CollectorService;
import org.graylog.plugins.sidecar.services.ConfigurationService;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.graylog2.database.PaginatedDbService;
import org.graylog2.database.PaginatedList;
import org.graylog2.search.SearchQuery;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;

public class SidecarService
extends PaginatedDbService<Sidecar> {
    private static final String COLLECTION_NAME = "sidecars";
    private final CollectorService collectorService;
    private final ConfigurationService configurationService;
    private final Validator validator;

    @Inject
    public SidecarService(CollectorService collectorService, ConfigurationService configurationService, MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, Validator validator) {
        super(mongoConnection, mapper, Sidecar.class, COLLECTION_NAME);
        this.collectorService = collectorService;
        this.configurationService = configurationService;
        this.validator = validator;
        this.db.createIndex((DBObject)new BasicDBObject("node_id", (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
    }

    public long count() {
        return this.db.count();
    }

    @Override
    public Sidecar save(Sidecar sidecar) {
        if (sidecar != null) {
            Set violations = this.validator.validate((Object)sidecar, new Class[0]);
            if (violations.isEmpty()) {
                return (Sidecar)this.db.findAndModify(DBQuery.is((String)"node_id", (Object)sidecar.nodeId()), (DBObject)new BasicDBObject(), (DBObject)new BasicDBObject(), false, (Object)sidecar, true, true);
            }
            throw new IllegalArgumentException("Specified object failed validation: " + violations);
        }
        throw new IllegalArgumentException("Specified object is not of correct implementation type (" + sidecar.getClass() + ")!");
    }

    public List<Sidecar> all() {
        try (Stream collectorStream = this.streamAll();){
            List<Sidecar> list = collectorStream.collect(Collectors.toList());
            return list;
        }
    }

    public Sidecar findByNodeId(String id) {
        return (Sidecar)this.db.findOne(DBQuery.is((String)"node_id", (Object)id));
    }

    public PaginatedList<Sidecar> findPaginated(SearchQuery searchQuery, int page, int perPage, String sortField, String order) {
        DBQuery.Query dbQuery = searchQuery.toDBQuery();
        DBSort.SortBuilder sortBuilder = this.getSortBuilder(order, sortField);
        return this.findPaginatedWithQueryAndSort(dbQuery, sortBuilder, page, perPage);
    }

    public PaginatedList<Sidecar> findPaginated(SearchQuery searchQuery, Predicate<Sidecar> filter, int page, int perPage, String sortField, String order) {
        DBQuery.Query dbQuery = searchQuery.toDBQuery();
        DBSort.SortBuilder sortBuilder = this.getSortBuilder(order, sortField);
        if (filter == null) {
            return this.findPaginatedWithQueryAndSort(dbQuery, sortBuilder, page, perPage);
        }
        return this.findPaginatedWithQueryFilterAndSort(dbQuery, filter, sortBuilder, page, perPage);
    }

    public int destroyExpired(Period period) {
        int count;
        DateTime threshold = DateTime.now((DateTimeZone)DateTimeZone.UTC).minus((ReadablePeriod)period);
        try (Stream collectorStream = this.streamAll();){
            count = collectorStream.mapToInt(collector -> {
                if (collector.lastSeen().isBefore((ReadableInstant)threshold)) {
                    return this.delete(collector.id());
                }
                return 0;
            }).sum();
        }
        return count;
    }

    public int markExpired(Period period, String message) {
        int count;
        DateTime threshold = DateTime.now((DateTimeZone)DateTimeZone.UTC).minus((ReadablePeriod)period);
        try (Stream collectorStream = this.streamAll();){
            count = collectorStream.mapToInt(collector -> {
                if (collector.nodeDetails().statusList() == null) {
                    return 0;
                }
                CollectorStatusList sidecarStatus = collector.nodeDetails().statusList();
                if (collector.lastSeen().isBefore((ReadableInstant)threshold) && Sidecar.Status.RUNNING.equals((Object)Sidecar.Status.fromStatusCode(sidecarStatus.status()))) {
                    NodeDetails nodeDetails = collector.nodeDetails();
                    ImmutableSet.Builder collectorStatuses = ImmutableSet.builder();
                    for (CollectorStatus collectorStatus : sidecarStatus.collectors()) {
                        collectorStatuses.add((Object)CollectorStatus.create(collectorStatus.collectorId(), Sidecar.Status.UNKNOWN.getStatusCode(), message));
                    }
                    CollectorStatusList statusListToSave = CollectorStatusList.create(Sidecar.Status.UNKNOWN.getStatusCode(), message, (Set<CollectorStatus>)collectorStatuses.build());
                    NodeDetails nodeDetailsToSave = NodeDetails.create(nodeDetails.operatingSystem(), nodeDetails.ip(), nodeDetails.metrics(), nodeDetails.logFileList(), statusListToSave);
                    Sidecar toSave = collector.toBuilder().nodeDetails(nodeDetailsToSave).build();
                    this.save(toSave);
                    return 1;
                }
                return 0;
            }).sum();
        }
        return count;
    }

    public Sidecar fromRequest(String nodeId, RegistrationRequest request, String collectorVersion) {
        return Sidecar.create(nodeId, request.nodeName(), NodeDetails.create(request.nodeDetails().operatingSystem(), request.nodeDetails().ip(), request.nodeDetails().metrics(), request.nodeDetails().logFileList(), request.nodeDetails().statusList()), collectorVersion);
    }

    public Sidecar assignConfiguration(String collectorNodeId, List<ConfigurationAssignment> assignments) throws NotFoundException {
        Sidecar sidecar = this.findByNodeId(collectorNodeId);
        if (sidecar == null) {
            throw new NotFoundException("Couldn't find collector with ID " + collectorNodeId);
        }
        for (ConfigurationAssignment assignment : assignments) {
            Collector collector = this.collectorService.find(assignment.collectorId());
            if (collector == null) {
                throw new NotFoundException("Couldn't find collector with ID " + assignment.collectorId());
            }
            Configuration configuration = this.configurationService.find(assignment.configurationId());
            if (configuration == null) {
                throw new NotFoundException("Couldn't find configuration with ID " + assignment.configurationId());
            }
            if (configuration.collectorId().equals(collector.id())) continue;
            throw new NotFoundException("Configuration doesn't match collector ID " + assignment.collectorId());
        }
        Sidecar toSave = sidecar.toBuilder().assignments(assignments).build();
        return this.save(toSave);
    }

    public List<SidecarSummary> toSummaryList(List<Sidecar> sidecars, Predicate<Sidecar> isActiveFunction) {
        return sidecars.stream().map(collector -> collector.toSummary(isActiveFunction)).collect(Collectors.toList());
    }
}

