/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.sidecar.system;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.graylog.plugins.sidecar.system.;
import org.graylog2.plugin.PluginConfigBean;
import org.joda.time.Period;

@JsonAutoDetect
@AutoValue
public abstract class SidecarConfiguration
implements PluginConfigBean {
    private static final Period DEFAULT_EXPIRATION_PERIOD = Period.days((int)14);
    private static final Period DEFAULT_INACTIVE_THRESHOLD = Period.minutes((int)1);
    private static final Period DEFAULT_UPDATE_INTERVAL = Period.seconds((int)30);
    private static final boolean DEFAULT_SEND_STATUS = true;
    private static final boolean DEFAULT_CONFIG_OVERRIDE = false;

    @JsonProperty(value="sidecar_expiration_threshold")
    public abstract Period sidecarExpirationThreshold();

    @JsonProperty(value="sidecar_inactive_threshold")
    public abstract Period sidecarInactiveThreshold();

    @JsonProperty(value="sidecar_update_interval")
    public abstract Period sidecarUpdateInterval();

    @JsonProperty(value="sidecar_send_status")
    public abstract boolean sidecarSendStatus();

    @JsonProperty(value="sidecar_configuration_override")
    public abstract boolean sidecarConfigurationOverride();

    @JsonCreator
    public static SidecarConfiguration create(@JsonProperty(value="sidecar_expiration_threshold") Period expirationThreshold, @JsonProperty(value="sidecar_inactive_threshold") Period inactiveThreshold, @JsonProperty(value="sidecar_update_interval") @Nullable Period updateInterval, @JsonProperty(value="sidecar_send_status") @Nullable Boolean sendStatus, @JsonProperty(value="sidecar_configuration_override") @Nullable Boolean configurationOverride) {
        return SidecarConfiguration.builder().sidecarExpirationThreshold(expirationThreshold).sidecarInactiveThreshold(inactiveThreshold).sidecarUpdateInterval((Period)MoreObjects.firstNonNull((Object)updateInterval, (Object)DEFAULT_UPDATE_INTERVAL)).sidecarSendStatus((Boolean)MoreObjects.firstNonNull((Object)sendStatus, (Object)true)).sidecarConfigurationOverride((Boolean)MoreObjects.firstNonNull((Object)configurationOverride, (Object)false)).build();
    }

    public static SidecarConfiguration defaultConfiguration() {
        return SidecarConfiguration.builder().sidecarExpirationThreshold(DEFAULT_EXPIRATION_PERIOD).sidecarInactiveThreshold(DEFAULT_INACTIVE_THRESHOLD).sidecarUpdateInterval(DEFAULT_UPDATE_INTERVAL).sidecarSendStatus(true).sidecarConfigurationOverride(false).build();
    }

    public static Builder builder() {
        return new .AutoValue_SidecarConfiguration.Builder();
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder sidecarExpirationThreshold(Period var1);

        public abstract Builder sidecarInactiveThreshold(Period var1);

        public abstract Builder sidecarUpdateInterval(Period var1);

        public abstract Builder sidecarSendStatus(boolean var1);

        public abstract Builder sidecarConfigurationOverride(boolean var1);

        public abstract SidecarConfiguration build();
    }
}

