/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.alerts;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog2.alarmcallbacks.AlarmCallbackHistory;
import org.graylog2.alarmcallbacks.AlarmCallbackHistoryService;
import org.graylog2.alerts.Alert;
import org.graylog2.alerts.AlertConditionFactory;
import org.graylog2.alerts.AlertImpl;
import org.graylog2.alerts.AlertService;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.CollectionName;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.alarms.AlertCondition;
import org.graylog2.plugin.configuration.ConfigurationException;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.rest.models.streams.alerts.requests.CreateConditionRequest;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;
import org.mongojack.JacksonDBCollection;

public class AlertServiceImpl
implements AlertService {
    private final JacksonDBCollection<AlertImpl, String> coll;
    private final AlertConditionFactory alertConditionFactory;
    private final AlarmCallbackHistoryService alarmCallbackHistoryService;

    @Inject
    public AlertServiceImpl(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapperProvider, AlertConditionFactory alertConditionFactory, AlarmCallbackHistoryService alarmCallbackHistoryService) {
        this.alertConditionFactory = alertConditionFactory;
        this.alarmCallbackHistoryService = alarmCallbackHistoryService;
        String collectionName = AlertImpl.class.getAnnotation(CollectionName.class).value();
        DBCollection dbCollection = mongoConnection.getDatabase().getCollection(collectionName);
        dbCollection.createIndex((DBObject)new BasicDBObject((Map)ImmutableMap.of((Object)"triggered_at", (Object)-1, (Object)"stream_id", (Object)1)));
        this.coll = JacksonDBCollection.wrap((DBCollection)dbCollection, AlertImpl.class, String.class, (ObjectMapper)mapperProvider.get());
    }

    @Override
    public Alert factory(AlertCondition.CheckResult checkResult) {
        Preconditions.checkArgument((boolean)checkResult.isTriggered(), (Object)"Unable to create alert for CheckResult which is not triggered.");
        return AlertImpl.fromCheckResult(checkResult);
    }

    @Override
    public List<Alert> loadRecentOfStreams(List<String> streamIds, DateTime since, int limit) {
        if (streamIds == null || streamIds.isEmpty()) {
            return Collections.emptyList();
        }
        DateTime effectiveSince = since == null ? new DateTime(0L, DateTimeZone.UTC) : since;
        DBQuery.Query query = DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{this.getFindAnyStreamQuery(streamIds), DBQuery.greaterThanEquals((String)"triggered_at", (Object)effectiveSince)});
        return Collections.unmodifiableList(this.coll.find(query).limit(limit).sort((DBObject)DBSort.desc((String)"triggered_at")).toArray());
    }

    @Override
    public List<Alert> loadRecentOfStream(String streamId, DateTime since, int limit) {
        return this.loadRecentOfStreams((List<String>)ImmutableList.of((Object)streamId), since, limit);
    }

    @VisibleForTesting
    int resolvedSecondsAgo(String streamId, String conditionId) {
        Optional<Alert> lastTriggeredAlert = this.getLastTriggeredAlert(streamId, conditionId);
        if (!lastTriggeredAlert.isPresent()) {
            return -1;
        }
        Alert mostRecentAlert = lastTriggeredAlert.get();
        DateTime resolvedAt = mostRecentAlert.getResolvedAt();
        if (resolvedAt == null || !this.isResolved(mostRecentAlert)) {
            return -1;
        }
        return Seconds.secondsBetween((ReadableInstant)resolvedAt, (ReadableInstant)Tools.nowUTC()).getSeconds();
    }

    @Override
    public Optional<Alert> getLastTriggeredAlert(String streamId, String conditionId) {
        List alert = this.coll.find(DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.is((String)"stream_id", (Object)streamId), DBQuery.is((String)"condition_id", (Object)conditionId)})).sort((DBObject)DBSort.desc((String)"triggered_at")).limit(1).toArray();
        if (alert == null || alert.size() == 0) {
            return Optional.empty();
        }
        return Optional.of((Alert)alert.get(0));
    }

    @Override
    public long totalCount() {
        return this.coll.count();
    }

    @Override
    public long totalCountForStream(String streamId) {
        return this.totalCountForStreams((List<String>)ImmutableList.of((Object)streamId), Alert.AlertState.ANY);
    }

    @Override
    public long totalCountForStreams(List<String> streamIds, Alert.AlertState state) {
        if (streamIds == null || streamIds.isEmpty()) {
            return 0L;
        }
        DBQuery.Query query = this.getFindAnyStreamQuery(streamIds);
        if (state != null && state != Alert.AlertState.ANY) {
            query = DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{query, this.getFindByStateQuery(state)});
        }
        return this.coll.count(this.coll.serializeQuery(query));
    }

    @Override
    public AlertCondition fromPersisted(Map<String, Object> fields, Stream stream) throws ConfigurationException {
        String type = (String)fields.get("type");
        return this.alertConditionFactory.createAlertCondition(type, stream, (String)fields.get("id"), DateTime.parse((String)((String)fields.get("created_at"))), (String)fields.get("creator_user_id"), (Map)fields.get("parameters"), (String)fields.get("title"));
    }

    @Override
    public AlertCondition fromRequest(CreateConditionRequest ccr, Stream stream, String userId) throws ConfigurationException {
        String type = ccr.type();
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Missing alert condition type");
        return this.alertConditionFactory.createAlertCondition(type, stream, null, Tools.nowUTC(), userId, ccr.parameters(), ccr.title());
    }

    @Override
    public AlertCondition updateFromRequest(AlertCondition alertCondition, CreateConditionRequest ccr) throws ConfigurationException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.putAll(alertCondition.getParameters());
        parameters.putAll(ccr.parameters());
        return this.alertConditionFactory.createAlertCondition(alertCondition.getType(), alertCondition.getStream(), alertCondition.getId(), alertCondition.getCreatedAt(), alertCondition.getCreatorUserId(), parameters, ccr.title());
    }

    @Override
    public boolean inGracePeriod(AlertCondition alertCondition) {
        int lastAlertSecondsAgo = this.resolvedSecondsAgo(alertCondition.getStream().getId(), alertCondition.getId());
        if (lastAlertSecondsAgo == -1 || alertCondition.getGrace() == 0) {
            return false;
        }
        return lastAlertSecondsAgo < alertCondition.getGrace() * 60;
    }

    @Override
    public boolean shouldRepeatNotifications(AlertCondition alertCondition, Alert alert) {
        if (!alert.isInterval() || this.isResolved(alert) || !alertCondition.shouldRepeatNotifications()) {
            return false;
        }
        if (alertCondition.getGrace() == 0) {
            return true;
        }
        AlarmCallbackHistory lastTriggeredAlertHistory = null;
        for (AlarmCallbackHistory history : this.alarmCallbackHistoryService.getForAlertId(alert.getId())) {
            if (lastTriggeredAlertHistory != null && !lastTriggeredAlertHistory.createdAt().isBefore((ReadableInstant)history.createdAt())) continue;
            lastTriggeredAlertHistory = history;
        }
        if (lastTriggeredAlertHistory == null) {
            return true;
        }
        int lastAlertSecondsAgo = Seconds.secondsBetween((ReadableInstant)lastTriggeredAlertHistory.createdAt(), (ReadableInstant)Tools.nowUTC()).getSeconds();
        return lastAlertSecondsAgo >= alertCondition.getGrace() * 60;
    }

    @Override
    public List<Alert> listForStreamIds(List<String> streamIds, Alert.AlertState state, int skip, int limit) {
        if (streamIds == null || streamIds.isEmpty()) {
            return Collections.emptyList();
        }
        DBQuery.Query query = this.getFindAnyStreamQuery(streamIds);
        if (state != null && state != Alert.AlertState.ANY) {
            query = DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{query, this.getFindByStateQuery(state)});
        }
        return Collections.unmodifiableList(this.coll.find(query).sort((DBObject)DBSort.desc((String)"triggered_at")).skip(skip).limit(limit).toArray());
    }

    @Override
    public List<Alert> listForStreamId(String streamId, int skip, int limit) {
        return this.listForStreamIds((List<String>)ImmutableList.of((Object)streamId), Alert.AlertState.ANY, skip, limit);
    }

    @Override
    public Alert load(String alertId, String streamId) throws NotFoundException {
        return (Alert)this.coll.findOneById((Object)alertId);
    }

    @Override
    public String save(Alert alert) throws ValidationException {
        Preconditions.checkArgument((boolean)(alert instanceof AlertImpl), (Object)("Supplied argument must be of type " + AlertImpl.class + ", and not " + alert.getClass()));
        return (String)this.coll.save((Object)((AlertImpl)alert)).getSavedId();
    }

    @Override
    public Alert resolveAlert(Alert alert) {
        if (alert == null || this.isResolved(alert)) {
            return alert;
        }
        AlertImpl updatedAlert = ((AlertImpl)alert).toBuilder().resolvedAt(Tools.nowUTC()).build();
        this.coll.save((Object)updatedAlert);
        return updatedAlert;
    }

    @Override
    public boolean isResolved(Alert alert) {
        return !alert.isInterval() || alert.getResolvedAt() != null;
    }

    private DBQuery.Query getFindAnyStreamQuery(List<String> streamIds) {
        List<DBQuery.Query> streamQueries = streamIds.stream().map(streamId -> DBQuery.is((String)"stream_id", (Object)streamId)).collect(Collectors.toList());
        return DBQuery.or((DBQuery.Query[])streamQueries.toArray(new DBQuery.Query[streamQueries.size()]));
    }

    private DBQuery.Query getFindByStateQuery(Alert.AlertState state) {
        if (state == Alert.AlertState.RESOLVED) {
            return DBQuery.or((DBQuery.Query[])new DBQuery.Query[]{DBQuery.notEquals((String)"is_interval", (Object)true), DBQuery.notEquals((String)"resolved_at", null)});
        }
        if (state == Alert.AlertState.UNRESOLVED) {
            return DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.is((String)"is_interval", (Object)true), DBQuery.is((String)"resolved_at", null)});
        }
        return DBQuery.empty();
    }
}

