/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.audit.jersey;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.core.Configuration;
import org.glassfish.jersey.server.model.ModelProcessor;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceModel;
import org.graylog2.audit.PluginAuditEventTypes;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.rest.RestTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditEventModelProcessor
implements ModelProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AuditEventModelProcessor.class);
    private final Set<String> auditEventTypes;

    public AuditEventModelProcessor(Set<PluginAuditEventTypes> auditEventTypes) {
        this.auditEventTypes = auditEventTypes.stream().flatMap(types -> types.auditEventTypes().stream()).collect(Collectors.toSet());
    }

    public ResourceModel processResourceModel(ResourceModel resourceModel, Configuration configuration) {
        this.checkResources(resourceModel.getResources());
        return resourceModel;
    }

    public ResourceModel processSubResource(ResourceModel subResourceModel, Configuration configuration) {
        this.checkResources(subResourceModel.getResources());
        return subResourceModel;
    }

    private void checkResources(List<Resource> resources) {
        for (Resource resource : resources) {
            for (ResourceMethod method : resource.getResourceMethods()) {
                Annotation annotation;
                Method m = method.getInvocable().getDefinitionMethod();
                if (!m.isAnnotationPresent(POST.class) && !m.isAnnotationPresent(PUT.class) && !m.isAnnotationPresent(DELETE.class)) continue;
                if (!m.isAnnotationPresent(AuditEvent.class) && !m.isAnnotationPresent(NoAuditEvent.class)) {
                    LOG.warn("REST endpoint not included in audit trail: {}", (Object)String.format(Locale.US, "%6s %s", method.getHttpMethod(), RestTools.getPathFromResource(resource)));
                    LOG.debug("Missing @AuditEvent or @NoAuditEvent annotation: {}#{}", (Object)m.getDeclaringClass().getCanonicalName(), (Object)m.getName());
                    continue;
                }
                if (m.isAnnotationPresent(AuditEvent.class)) {
                    annotation = m.getAnnotation(AuditEvent.class);
                    if (this.auditEventTypes.contains(annotation.type())) continue;
                    LOG.warn("REST endpoint does not use a registered audit type: {} (type: \"{}\")", (Object)String.format(Locale.US, "%6s %s", method.getHttpMethod(), RestTools.getPathFromResource(resource)), (Object)annotation.type());
                    LOG.debug("Make sure the audit event types are registered in a class that implements PluginAuditEventTypes: {}#{}", (Object)m.getDeclaringClass().getCanonicalName(), (Object)m.getName());
                    continue;
                }
                if (!m.isAnnotationPresent(NoAuditEvent.class) || !Strings.isNullOrEmpty((String)(annotation = m.getAnnotation(NoAuditEvent.class)).value())) continue;
                LOG.warn("REST endpoint uses @NoAuditEvent annotation with an empty value: {}", (Object)String.format(Locale.US, "%6s %s", method.getHttpMethod(), RestTools.getPathFromResource(resource)));
            }
            this.checkResources(resource.getChildResources());
        }
    }
}

