/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bindings.providers;

import com.codahale.metrics.InstrumentedExecutorService;
import com.codahale.metrics.MetricRegistry;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.shared.events.DeadEventLoggingListener;

public class ClusterEventBusProvider
implements Provider<ClusterEventBus> {
    private final int asyncEventbusProcessors;
    private final MetricRegistry metricRegistry;

    @Inject
    public ClusterEventBusProvider(@Named(value="async_eventbus_processors") int asyncEventbusProcessors, MetricRegistry metricRegistry) {
        this.asyncEventbusProcessors = asyncEventbusProcessors;
        this.metricRegistry = metricRegistry;
    }

    public ClusterEventBus get() {
        ClusterEventBus eventBus = new ClusterEventBus("cluster-eventbus", this.executorService(this.asyncEventbusProcessors));
        eventBus.registerClusterEventSubscriber(new DeadEventLoggingListener());
        return eventBus;
    }

    private ExecutorService executorService(int nThreads) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("cluster-eventbus-handler-%d").build();
        return new InstrumentedExecutorService(Executors.newFixedThreadPool(nThreads, threadFactory), this.metricRegistry, MetricRegistry.name((String)"cluster-eventbus", (String[])new String[]{"executor-service"}));
    }
}

