/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bundles;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mongodb.BasicDBObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.graylog2.bundles.ConfigurationBundle;
import org.graylog2.bundles.Converter;
import org.graylog2.bundles.Dashboard;
import org.graylog2.bundles.DashboardWidget;
import org.graylog2.bundles.ExportBundle;
import org.graylog2.bundles.Extractor;
import org.graylog2.bundles.GrokPattern;
import org.graylog2.bundles.Input;
import org.graylog2.bundles.LookupCacheBundle;
import org.graylog2.bundles.LookupDataAdapterBundle;
import org.graylog2.bundles.LookupTableBundle;
import org.graylog2.bundles.Output;
import org.graylog2.bundles.Stream;
import org.graylog2.bundles.StreamRule;
import org.graylog2.dashboards.DashboardService;
import org.graylog2.dashboards.widgets.DashboardWidgetCreator;
import org.graylog2.database.NotFoundException;
import org.graylog2.grok.GrokPatternService;
import org.graylog2.inputs.InputService;
import org.graylog2.jackson.TypeReferences;
import org.graylog2.lookup.db.DBCacheService;
import org.graylog2.lookup.db.DBDataAdapterService;
import org.graylog2.lookup.db.DBLookupTableService;
import org.graylog2.lookup.dto.CacheDto;
import org.graylog2.lookup.dto.DataAdapterDto;
import org.graylog2.lookup.dto.LookupTableDto;
import org.graylog2.plugin.inputs.Converter;
import org.graylog2.streams.OutputService;
import org.graylog2.streams.StreamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleExporter {
    private static final Logger LOG = LoggerFactory.getLogger(BundleExporter.class);
    private final InputService inputService;
    private final StreamService streamService;
    private final OutputService outputService;
    private final DashboardService dashboardService;
    private final DashboardWidgetCreator dashboardWidgetCreator;
    private final DBLookupTableService dbLookupTableService;
    private final DBCacheService dbCacheService;
    private final DBDataAdapterService dbDataAdapterService;
    private final GrokPatternService grokPatternService;
    private final ObjectMapper objectMapper;
    private Set<String> streamSet = new HashSet<String>();

    @Inject
    public BundleExporter(InputService inputService, StreamService streamService, OutputService outputService, DashboardService dashboardService, DashboardWidgetCreator dashboardWidgetCreator, DBLookupTableService dbLookupTableService, DBCacheService dbCacheService, DBDataAdapterService dbDataAdapterService, GrokPatternService grokPatternService, ObjectMapper objectMapper) {
        this.inputService = inputService;
        this.streamService = streamService;
        this.outputService = outputService;
        this.dashboardService = dashboardService;
        this.dashboardWidgetCreator = dashboardWidgetCreator;
        this.dbLookupTableService = dbLookupTableService;
        this.dbCacheService = dbCacheService;
        this.dbDataAdapterService = dbDataAdapterService;
        this.grokPatternService = grokPatternService;
        this.objectMapper = objectMapper;
    }

    public ConfigurationBundle export(ExportBundle exportBundle) {
        ConfigurationBundle configurationBundle = new ConfigurationBundle();
        this.streamSet = new HashSet<String>(exportBundle.getStreams());
        Set<Dashboard> dashboards = this.exportDashboards(exportBundle.getDashboards());
        Set<Output> outputs = this.exportOutputs(exportBundle.getOutputs());
        Set<Stream> streams = this.exportStreams(this.streamSet);
        Set<GrokPattern> grokPatterns = this.exportGrokPatterns(exportBundle.getGrokPatterns());
        Set<Input> inputs = this.exportInputs(exportBundle.getInputs());
        Set<LookupTableBundle> lookupTables = this.exportLookupTables(exportBundle.getLookupTables());
        Set<LookupCacheBundle> lookupCaches = this.exportLookupCaches(exportBundle.getLookupCaches());
        Set<LookupDataAdapterBundle> lookupDataAdapters = this.exportLookupDataAdapters(exportBundle.getLookupDataAdapters());
        configurationBundle.setName(exportBundle.getName());
        configurationBundle.setCategory(exportBundle.getCategory());
        configurationBundle.setDescription(exportBundle.getDescription());
        configurationBundle.setGrokPatterns(grokPatterns);
        configurationBundle.setInputs(inputs);
        configurationBundle.setStreams(streams);
        configurationBundle.setOutputs(outputs);
        configurationBundle.setDashboards(dashboards);
        configurationBundle.setLookupTables(lookupTables);
        configurationBundle.setLookupCaches(lookupCaches);
        configurationBundle.setLookupDataAdapters(lookupDataAdapters);
        return configurationBundle;
    }

    private Set<LookupDataAdapterBundle> exportLookupDataAdapters(Set<String> lookupDataAdapters) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String id : lookupDataAdapters) {
            LookupDataAdapterBundle bundle = this.exportLookupDataAdapter(id);
            if (bundle == null) continue;
            builder.add((Object)bundle);
        }
        return builder.build();
    }

    private LookupDataAdapterBundle exportLookupDataAdapter(String id) {
        Optional<DataAdapterDto> dtoOptional = this.dbDataAdapterService.get(id);
        if (!dtoOptional.isPresent()) {
            return null;
        }
        DataAdapterDto dto = dtoOptional.get();
        LookupDataAdapterBundle bundle = new LookupDataAdapterBundle();
        bundle.setTitle(dto.title());
        bundle.setDescription(dto.description());
        bundle.setName(dto.name());
        bundle.setConfig((Map)this.objectMapper.convertValue((Object)dto.config(), TypeReferences.MAP_STRING_OBJECT));
        return bundle;
    }

    private Set<LookupCacheBundle> exportLookupCaches(Set<String> lookupCaches) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String id : lookupCaches) {
            LookupCacheBundle bundle = this.exportLookupCache(id);
            if (bundle == null) continue;
            builder.add((Object)bundle);
        }
        return builder.build();
    }

    @Nullable
    private LookupCacheBundle exportLookupCache(String id) {
        Optional<CacheDto> dtoOptional = this.dbCacheService.get(id);
        if (!dtoOptional.isPresent()) {
            return null;
        }
        CacheDto dto = dtoOptional.get();
        LookupCacheBundle bundle = new LookupCacheBundle();
        bundle.setTitle(dto.title());
        bundle.setDescription(dto.description());
        bundle.setName(dto.name());
        bundle.setConfig((Map)this.objectMapper.convertValue((Object)dto.config(), TypeReferences.MAP_STRING_OBJECT));
        return bundle;
    }

    private Set<LookupTableBundle> exportLookupTables(Set<String> lookupTables) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String id : lookupTables) {
            LookupTableBundle bundle = this.exportLookupTable(id);
            if (bundle == null) continue;
            builder.add((Object)bundle);
        }
        return builder.build();
    }

    @Nullable
    private LookupTableBundle exportLookupTable(String tableId) {
        Optional<LookupTableDto> dtoOptional = this.dbLookupTableService.get(tableId);
        if (!dtoOptional.isPresent()) {
            return null;
        }
        LookupTableDto dto = dtoOptional.get();
        Optional<CacheDto> cacheDtoOptional = this.dbCacheService.get(dto.cacheId());
        Optional<DataAdapterDto> adapterDtoOptional = this.dbDataAdapterService.get(dto.dataAdapterId());
        if (!cacheDtoOptional.isPresent() || !adapterDtoOptional.isPresent()) {
            LOG.warn("Skipping bundle export of incomplete lookup table <{}> ({})", (Object)dto.name(), (Object)dto.id());
            return null;
        }
        LookupTableBundle bundle = new LookupTableBundle();
        bundle.setTitle(dto.title());
        bundle.setDescription(dto.description());
        bundle.setName(dto.name());
        bundle.setCacheName(cacheDtoOptional.get().name());
        bundle.setDataAdapterName(adapterDtoOptional.get().name());
        bundle.setDefaultSingleValue(dto.defaultSingleValue());
        bundle.setDefaultSingleValueType(dto.defaultSingleValueType());
        bundle.setDefaultMultiValue(dto.defaultMultiValue());
        bundle.setDefaultMultiValueType(dto.defaultMultiValueType());
        return bundle;
    }

    private Set<GrokPattern> exportGrokPatterns(Set<String> grokPatterns) {
        ImmutableSet.Builder grokPatternBuilder = ImmutableSet.builder();
        for (String name : grokPatterns) {
            GrokPattern grokPattern = this.exportGrokPattern(name);
            if (grokPattern == null) continue;
            grokPatternBuilder.add((Object)grokPattern);
        }
        return grokPatternBuilder.build();
    }

    private GrokPattern exportGrokPattern(String grokPatternName) {
        org.graylog2.grok.GrokPattern grokPattern;
        try {
            grokPattern = this.grokPatternService.load(grokPatternName);
        }
        catch (NotFoundException e) {
            LOG.debug("Requested grok pattern \"{}\" not found.", (Object)grokPatternName);
            return null;
        }
        return GrokPattern.create(grokPattern.name(), grokPattern.pattern());
    }

    private Set<Input> exportInputs(Set<String> inputs) {
        ImmutableSet.Builder inputBuilder = ImmutableSet.builder();
        for (String inputId : inputs) {
            Input input = this.exportInput(inputId);
            if (input == null) continue;
            inputBuilder.add((Object)input);
        }
        return inputBuilder.build();
    }

    private Input exportInput(String inputId) {
        org.graylog2.inputs.Input input;
        try {
            input = this.inputService.find(inputId);
        }
        catch (NotFoundException e) {
            LOG.debug("Requested input {} not found.", (Object)inputId);
            return null;
        }
        Input inputDescription = new Input();
        inputDescription.setId(input.getId());
        inputDescription.setTitle(input.getTitle());
        inputDescription.setType(input.getType());
        inputDescription.setGlobal(input.isGlobal());
        inputDescription.setConfiguration(input.getConfiguration());
        inputDescription.setStaticFields(input.getStaticFields());
        inputDescription.setExtractors(this.exportExtractors(input));
        return inputDescription;
    }

    private List<Extractor> exportExtractors(org.graylog2.inputs.Input input) {
        ImmutableList.Builder extractorBuilder = ImmutableList.builder();
        List<org.graylog2.plugin.inputs.Extractor> extractors = this.inputService.getExtractors(input);
        for (org.graylog2.plugin.inputs.Extractor extractor : extractors) {
            extractorBuilder.add((Object)this.exportExtractor(extractor));
        }
        return extractorBuilder.build();
    }

    private Extractor exportExtractor(org.graylog2.plugin.inputs.Extractor extractor) {
        Extractor extractorDescription = new Extractor();
        extractorDescription.setTitle(extractor.getTitle());
        extractorDescription.setType(extractor.getType());
        extractorDescription.setConfiguration(extractor.getExtractorConfig());
        extractorDescription.setConditionType(extractor.getConditionType());
        extractorDescription.setConditionValue(extractor.getConditionValue());
        extractorDescription.setCursorStrategy(extractor.getCursorStrategy());
        extractorDescription.setOrder(extractor.getOrder().intValue());
        extractorDescription.setSourceField(extractor.getSourceField());
        extractorDescription.setTargetField(extractor.getTargetField());
        List<org.graylog2.plugin.inputs.Converter> converters = extractor.getConverters();
        extractorDescription.setConverters(this.exportConverters(converters));
        return extractorDescription;
    }

    private List<Converter> exportConverters(List<org.graylog2.plugin.inputs.Converter> converters) {
        ImmutableList.Builder converterBuilder = ImmutableList.builder();
        for (org.graylog2.plugin.inputs.Converter converter : converters) {
            Converter converterDescription = new Converter();
            Converter.Type type = converter.getType();
            converterDescription.setType(type);
            converterDescription.setConfiguration(converter.getConfig());
            converterBuilder.add((Object)converterDescription);
        }
        return converterBuilder.build();
    }

    private Set<Stream> exportStreams(Set<String> streams) {
        ImmutableSet.Builder streamBuilder = ImmutableSet.builder();
        for (String streamId : streams) {
            Stream stream = this.exportStream(streamId);
            if (stream == null) continue;
            streamBuilder.add((Object)stream);
        }
        return streamBuilder.build();
    }

    private Stream exportStream(String streamId) {
        org.graylog2.plugin.streams.Stream stream;
        try {
            stream = this.streamService.load(streamId);
        }
        catch (NotFoundException e) {
            LOG.debug("Requested stream {} not found.", (Object)streamId);
            return null;
        }
        Stream streamDescription = new Stream();
        streamDescription.setId(stream.getId());
        streamDescription.setTitle(stream.getTitle());
        streamDescription.setDescription(stream.getDescription());
        streamDescription.setDisabled(stream.getDisabled());
        streamDescription.setMatchingType(stream.getMatchingType());
        streamDescription.setOutputs(this.exportOutputReferences(stream.getOutputs()));
        streamDescription.setStreamRules(this.exportStreamRules(stream.getStreamRules()));
        streamDescription.setDefaultStream(stream.isDefaultStream());
        return streamDescription;
    }

    private List<StreamRule> exportStreamRules(List<org.graylog2.plugin.streams.StreamRule> streamRules) {
        ImmutableList.Builder streamRuleBuilder = ImmutableList.builder();
        for (org.graylog2.plugin.streams.StreamRule streamRule : streamRules) {
            StreamRule streamRuleDescription = new StreamRule();
            streamRuleDescription.setType(streamRule.getType());
            streamRuleDescription.setField(streamRule.getField());
            streamRuleDescription.setValue(streamRule.getValue());
            streamRuleDescription.setInverted(streamRule.getInverted());
            streamRuleDescription.setDescription(streamRule.getDescription());
            streamRuleBuilder.add((Object)streamRuleDescription);
        }
        return streamRuleBuilder.build();
    }

    private Set<String> exportOutputReferences(Set<org.graylog2.plugin.streams.Output> outputs) {
        ImmutableSet.Builder outputBuilder = ImmutableSet.builder();
        for (org.graylog2.plugin.streams.Output output : outputs) {
            outputBuilder.add((Object)output.getId());
        }
        return outputBuilder.build();
    }

    private Set<Output> exportOutputs(Set<String> outputs) {
        ImmutableSet.Builder outputBuilder = ImmutableSet.builder();
        for (String outputId : outputs) {
            Output output = this.exportOutput(outputId);
            if (output == null) continue;
            outputBuilder.add((Object)output);
        }
        return outputBuilder.build();
    }

    private Output exportOutput(String outputId) {
        org.graylog2.plugin.streams.Output output;
        try {
            output = this.outputService.load(outputId);
        }
        catch (NotFoundException e) {
            LOG.debug("Requested output {} not found.", (Object)outputId);
            return null;
        }
        Output outputDescription = new Output();
        outputDescription.setId(output.getId());
        outputDescription.setTitle(output.getTitle());
        outputDescription.setType(output.getType());
        outputDescription.setConfiguration(output.getConfiguration());
        return outputDescription;
    }

    private Set<Dashboard> exportDashboards(Set<String> dashboards) {
        ImmutableSet.Builder dashboardBuilder = ImmutableSet.builder();
        for (String dashboardId : dashboards) {
            Dashboard dashboard = this.exportDashboard(dashboardId);
            if (dashboard == null) continue;
            dashboardBuilder.add((Object)dashboard);
        }
        return dashboardBuilder.build();
    }

    private Dashboard exportDashboard(String dashboardId) {
        org.graylog2.dashboards.Dashboard dashboard;
        try {
            dashboard = this.dashboardService.load(dashboardId);
        }
        catch (NotFoundException e) {
            LOG.debug("Requested dashboard {} not found.", (Object)dashboardId);
            return null;
        }
        Dashboard dashboardDescription = new Dashboard();
        dashboardDescription.setTitle(dashboard.getTitle());
        dashboardDescription.setDescription(dashboard.getDescription());
        dashboardDescription.setDashboardWidgets(this.exportDashboardWidgets(dashboard));
        return dashboardDescription;
    }

    private List<DashboardWidget> exportDashboardWidgets(org.graylog2.dashboards.Dashboard dashboard) {
        ImmutableList.Builder dashboardWidgetBuilder = ImmutableList.builder();
        Map<String, Object> fields = dashboard.getFields();
        Map positions = (Map)dashboard.asMap().get("positions");
        if (fields.containsKey("widgets")) {
            List embeddedWidgets = (List)fields.get("widgets");
            for (BasicDBObject widgetFields : embeddedWidgets) {
                Map widgetPosition;
                org.graylog2.dashboards.widgets.DashboardWidget widget;
                try {
                    widget = this.dashboardWidgetCreator.fromPersisted(widgetFields);
                }
                catch (Exception e) {
                    LOG.warn("Error while exporting widgets of dashboard " + dashboard.getId(), (Throwable)e);
                    continue;
                }
                DashboardWidget dashboardWidgetDescription = new DashboardWidget();
                Map<String, Object> widgetConfig = widget.getConfig();
                dashboardWidgetDescription.setDescription(widget.getDescription());
                dashboardWidgetDescription.setType(widget.getType());
                dashboardWidgetDescription.setConfiguration(widgetConfig);
                dashboardWidgetDescription.setCacheTime(widget.getCacheTime());
                Object streamId = widgetConfig.get("stream_id");
                if (streamId instanceof String && this.streamSet.add((String)streamId)) {
                    LOG.debug("Adding stream {} to export list", streamId);
                }
                if ((widgetPosition = (Map)positions.get(widget.getId())) != null) {
                    int row = widgetPosition.getOrDefault("row", 0);
                    int col = widgetPosition.getOrDefault("col", 0);
                    int height = widgetPosition.getOrDefault("height", 0);
                    int width = widgetPosition.getOrDefault("width", 0);
                    dashboardWidgetDescription.setRow(row);
                    dashboardWidgetDescription.setCol(col);
                    dashboardWidgetDescription.setHeight(height);
                    dashboardWidgetDescription.setWidth(width);
                } else {
                    LOG.debug("Couldn't find position for widget {} on dashboard {}, using defaults (0, 0, 0, 0).", (Object)widget.getId(), (Object)dashboard.getTitle());
                    dashboardWidgetDescription.setRow(0);
                    dashboardWidgetDescription.setCol(0);
                    dashboardWidgetDescription.setHeight(0);
                    dashboardWidgetDescription.setWidth(0);
                }
                dashboardWidgetBuilder.add((Object)dashboardWidgetDescription);
            }
        }
        return dashboardWidgetBuilder.build();
    }
}

