/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.configuration;

import com.github.joschi.jadconfig.Parameter;
import com.github.joschi.jadconfig.util.Duration;
import com.github.joschi.jadconfig.validators.PositiveDurationValidator;
import com.github.joschi.jadconfig.validators.PositiveIntegerValidator;
import com.github.joschi.jadconfig.validators.PositiveLongValidator;
import java.util.Locale;
import org.joda.time.Period;

public class ElasticsearchConfiguration {
    @Parameter(value="elasticsearch_disable_version_check")
    private boolean disableVersionCheck = false;
    @Deprecated
    @Parameter(value="elasticsearch_index_prefix", required=true)
    private String indexPrefix = "graylog";
    @Deprecated
    @Parameter(value="elasticsearch_max_number_of_indices", required=true, validator=PositiveIntegerValidator.class)
    private int maxNumberOfIndices = 20;
    @Deprecated
    @Parameter(value="elasticsearch_max_docs_per_index", validator=PositiveIntegerValidator.class, required=true)
    private int maxDocsPerIndex = 20000000;
    @Deprecated
    @Parameter(value="elasticsearch_max_size_per_index", validator=PositiveLongValidator.class, required=true)
    private long maxSizePerIndex = 0x40000000L;
    @Deprecated
    @Parameter(value="elasticsearch_max_time_per_index", required=true)
    private Period maxTimePerIndex = Period.days((int)1);
    @Deprecated
    @Parameter(value="elasticsearch_shards", validator=PositiveIntegerValidator.class, required=true)
    private int shards = 4;
    @Deprecated
    @Parameter(value="elasticsearch_replicas", validator=PositiveIntegerValidator.class, required=true)
    private int replicas = 0;
    @Deprecated
    @Parameter(value="elasticsearch_analyzer", required=true)
    private String analyzer = "standard";
    @Deprecated
    @Parameter(value="elasticsearch_template_name")
    private String templateName = "graylog-internal";
    @Parameter(value="no_retention")
    private boolean noRetention = false;
    @Deprecated
    @Parameter(value="retention_strategy", required=true)
    private String retentionStrategy = "delete";
    @Deprecated
    @Parameter(value="rotation_strategy")
    private String rotationStrategy = "count";
    @Deprecated
    @Parameter(value="disable_index_optimization")
    private boolean disableIndexOptimization = false;
    @Deprecated
    @Parameter(value="index_optimization_max_num_segments", validator=PositiveIntegerValidator.class)
    private int indexOptimizationMaxNumSegments = 1;
    @Parameter(value="elasticsearch_request_timeout", validator=PositiveDurationValidator.class)
    private Duration requestTimeout = Duration.minutes((long)1L);
    @Parameter(value="elasticsearch_index_optimization_timeout", validator=PositiveDurationValidator.class)
    private Duration indexOptimizationTimeout = Duration.hours((long)1L);
    @Parameter(value="elasticsearch_index_optimization_jobs", validator=PositiveIntegerValidator.class)
    private int indexOptimizationJobs = 20;
    @Parameter(value="index_field_type_periodical_interval", validator=PositiveDurationValidator.class)
    private Duration indexFieldTypePeriodicalInterval = Duration.hours((long)1L);

    public boolean isDisableVersionCheck() {
        return this.disableVersionCheck;
    }

    @Deprecated
    public String getIndexPrefix() {
        return this.indexPrefix.toLowerCase(Locale.ENGLISH);
    }

    @Deprecated
    public int getMaxNumberOfIndices() {
        return this.maxNumberOfIndices;
    }

    @Deprecated
    public int getMaxDocsPerIndex() {
        return this.maxDocsPerIndex;
    }

    @Deprecated
    public long getMaxSizePerIndex() {
        return this.maxSizePerIndex;
    }

    @Deprecated
    public Period getMaxTimePerIndex() {
        return this.maxTimePerIndex;
    }

    @Deprecated
    public int getShards() {
        return this.shards;
    }

    @Deprecated
    public int getReplicas() {
        return this.replicas;
    }

    @Deprecated
    public String getAnalyzer() {
        return this.analyzer;
    }

    @Deprecated
    public String getTemplateName() {
        return this.templateName;
    }

    @Deprecated
    public String getRotationStrategy() {
        return this.rotationStrategy;
    }

    public boolean performRetention() {
        return !this.noRetention;
    }

    @Deprecated
    public String getRetentionStrategy() {
        return this.retentionStrategy;
    }

    @Deprecated
    public int getIndexOptimizationMaxNumSegments() {
        return this.indexOptimizationMaxNumSegments;
    }

    @Deprecated
    public boolean isDisableIndexOptimization() {
        return this.disableIndexOptimization;
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public Duration getIndexOptimizationTimeout() {
        return this.indexOptimizationTimeout;
    }

    public int getIndexOptimizationJobs() {
        return this.indexOptimizationJobs;
    }

    public Duration getIndexFieldTypePeriodicalInterval() {
        return this.indexFieldTypePeriodicalInterval;
    }
}

