/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.DuplicateKeyException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.bson.types.ObjectId;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.contentpacks.model.ContentPack;
import org.graylog2.contentpacks.model.ModelId;
import org.graylog2.contentpacks.model.Revisioned;
import org.graylog2.database.MongoConnection;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ContentPackPersistenceService {
    public static final String COLLECTION_NAME = "content_packs";
    private final JacksonDBCollection<ContentPack, ObjectId> dbCollection;
    private static final Logger LOG = LoggerFactory.getLogger(ContentPackPersistenceService.class);

    @Inject
    public ContentPackPersistenceService(MongoJackObjectMapperProvider mapperProvider, MongoConnection mongoConnection) {
        this((JacksonDBCollection<ContentPack, ObjectId>)JacksonDBCollection.wrap((DBCollection)mongoConnection.getDatabase().getCollection(COLLECTION_NAME), ContentPack.class, ObjectId.class, (ObjectMapper)mapperProvider.get()));
    }

    ContentPackPersistenceService(JacksonDBCollection<ContentPack, ObjectId> dbCollection) {
        this.dbCollection = dbCollection;
        try {
            dbCollection.createIndex((DBObject)new BasicDBObject("id", (Object)1).append("rev", (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
        }
        catch (DuplicateKeyException duplicateKeyException) {
            // empty catch block
        }
    }

    public Set<ContentPack> loadAll() {
        DBCursor contentPacks = this.dbCollection.find();
        return ImmutableSet.copyOf((Iterable)contentPacks);
    }

    public Set<ContentPack> loadAllLatest() {
        Set<ContentPack> allContentPacks = this.loadAll();
        ImmutableMultimap.Builder byIdBuilder = ImmutableMultimap.builder();
        for (ContentPack contentPack : allContentPacks) {
            byIdBuilder.put((Object)contentPack.id(), (Object)contentPack);
        }
        ImmutableMultimap contentPacksById = byIdBuilder.build();
        ImmutableSet.Builder latestContentPacks = ImmutableSet.builderWithExpectedSize((int)contentPacksById.keySet().size());
        for (ModelId id : contentPacksById.keySet()) {
            ImmutableCollection contentPacks = contentPacksById.get((Object)id);
            ContentPack latestContentPackRevision = Collections.max(contentPacks, Comparator.comparingInt(Revisioned::revision));
            latestContentPacks.add((Object)latestContentPackRevision);
        }
        return latestContentPacks.build();
    }

    public Set<ContentPack> findAllById(ModelId id) {
        DBCursor result = this.dbCollection.find(DBQuery.is((String)"id", (Object)id));
        return ImmutableSet.copyOf((Iterable)result);
    }

    public Optional<ContentPack> findByIdAndRevision(ModelId id, int revision) {
        DBQuery.Query query = (DBQuery.Query)DBQuery.is((String)"id", (Object)id).is("rev", (Object)revision);
        return Optional.ofNullable((ContentPack)this.dbCollection.findOne(query));
    }

    public Optional<ContentPack> insert(ContentPack pack) {
        if (this.findByIdAndRevision(pack.id(), pack.revision()).isPresent()) {
            LOG.debug("Content pack already found: id: {} revision: {}. Did not insert!", (Object)pack.id(), (Object)pack.revision());
            return Optional.empty();
        }
        WriteResult writeResult = this.dbCollection.insert((Object)pack);
        return Optional.of((ContentPack)writeResult.getSavedObject());
    }

    public int deleteById(ModelId id) {
        DBQuery.Query query = DBQuery.is((String)"id", (Object)id);
        WriteResult writeResult = this.dbCollection.remove(query);
        return writeResult.getN();
    }

    public int deleteByIdAndRevision(ModelId id, int revision) {
        DBQuery.Query query = (DBQuery.Query)DBQuery.is((String)"id", (Object)id).is("rev", (Object)revision);
        WriteResult writeResult = this.dbCollection.remove(query);
        return writeResult.getN();
    }
}

