/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.constraints;

import com.google.common.collect.ImmutableSet;
import com.vdurmont.semver4j.Requirement;
import com.vdurmont.semver4j.Semver;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog2.contentpacks.constraints.ConstraintChecker;
import org.graylog2.contentpacks.model.constraints.Constraint;
import org.graylog2.contentpacks.model.constraints.ConstraintCheckResult;
import org.graylog2.contentpacks.model.constraints.PluginVersionConstraint;
import org.graylog2.plugin.PluginMetaData;
import org.graylog2.plugin.Version;

public class PluginVersionConstraintChecker
implements ConstraintChecker {
    private final Set<Semver> pluginVersions;

    @Inject
    public PluginVersionConstraintChecker(Set<PluginMetaData> pluginMetaData) {
        this.pluginVersions = pluginMetaData.stream().map(PluginMetaData::getVersion).map(Version::toString).map(Semver::new).collect(Collectors.toSet());
    }

    @Override
    public Set<Constraint> ensureConstraints(Collection<Constraint> requestedConstraints) {
        ImmutableSet.Builder fulfilledConstraints = ImmutableSet.builder();
        for (Constraint constraint : requestedConstraints) {
            if (!(constraint instanceof PluginVersionConstraint)) continue;
            PluginVersionConstraint versionConstraint = (PluginVersionConstraint)constraint;
            Requirement requiredVersion = versionConstraint.version();
            for (Semver pluginVersion : this.pluginVersions) {
                if (!requiredVersion.isSatisfiedBy(pluginVersion)) continue;
                fulfilledConstraints.add((Object)constraint);
            }
        }
        return fulfilledConstraints.build();
    }

    @Override
    public Set<ConstraintCheckResult> checkConstraints(Collection<Constraint> requestedConstraints) {
        ImmutableSet.Builder fulfilledConstraints = ImmutableSet.builder();
        for (Constraint constraint : requestedConstraints) {
            if (!(constraint instanceof PluginVersionConstraint)) continue;
            PluginVersionConstraint versionConstraint = (PluginVersionConstraint)constraint;
            Requirement requiredVersion = versionConstraint.version();
            boolean result = false;
            for (Semver pluginVersion : this.pluginVersions) {
                if (!requiredVersion.isSatisfiedBy(pluginVersion)) continue;
                result = true;
            }
            ConstraintCheckResult constraintCheckResult = ConstraintCheckResult.create(versionConstraint, result);
            fulfilledConstraints.add((Object)constraintCheckResult);
        }
        return fulfilledConstraints.build();
    }
}

