/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.facades;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.MutableGraph;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.graylog2.contentpacks.exceptions.ContentPackException;
import org.graylog2.contentpacks.facades.EntityFacade;
import org.graylog2.contentpacks.model.ModelId;
import org.graylog2.contentpacks.model.ModelType;
import org.graylog2.contentpacks.model.ModelTypes;
import org.graylog2.contentpacks.model.entities.DashboardEntity;
import org.graylog2.contentpacks.model.entities.DashboardWidgetEntity;
import org.graylog2.contentpacks.model.entities.Entity;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.EntityExcerpt;
import org.graylog2.contentpacks.model.entities.EntityV1;
import org.graylog2.contentpacks.model.entities.EntityWithConstraints;
import org.graylog2.contentpacks.model.entities.NativeEntity;
import org.graylog2.contentpacks.model.entities.NativeEntityDescriptor;
import org.graylog2.contentpacks.model.entities.TimeRangeEntity;
import org.graylog2.contentpacks.model.entities.references.Reference;
import org.graylog2.contentpacks.model.entities.references.ReferenceMapUtils;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.dashboards.Dashboard;
import org.graylog2.dashboards.DashboardImpl;
import org.graylog2.dashboards.DashboardService;
import org.graylog2.dashboards.widgets.DashboardWidget;
import org.graylog2.dashboards.widgets.DashboardWidgetCreator;
import org.graylog2.dashboards.widgets.InvalidWidgetConfigurationException;
import org.graylog2.dashboards.widgets.WidgetPosition;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.rest.models.dashboards.requests.WidgetPositionsRequest;
import org.graylog2.timeranges.TimeRangeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DashboardFacade
implements EntityFacade<Dashboard> {
    private static final Logger LOG = LoggerFactory.getLogger(DashboardFacade.class);
    public static final ModelType TYPE_V1 = ModelTypes.DASHBOARD_V1;
    private final ObjectMapper objectMapper;
    private final DashboardService dashboardService;
    private final DashboardWidgetCreator widgetCreator;
    private final TimeRangeFactory timeRangeFactory;

    @Inject
    public DashboardFacade(ObjectMapper objectMapper, DashboardService dashboardService, DashboardWidgetCreator widgetCreator, TimeRangeFactory timeRangeFactory) {
        this.objectMapper = objectMapper;
        this.dashboardService = dashboardService;
        this.widgetCreator = widgetCreator;
        this.timeRangeFactory = timeRangeFactory;
    }

    @Override
    public EntityWithConstraints exportNativeEntity(Dashboard dashboard) {
        Map<String, WidgetPosition> positionsById = dashboard.getPositions().stream().collect(Collectors.toMap(WidgetPosition::id, v -> v));
        List<DashboardWidgetEntity> dashboardWidgets = dashboard.getWidgets().entrySet().stream().map(widget -> this.encodeWidget((DashboardWidget)widget.getValue(), (WidgetPosition)positionsById.get(widget.getKey()))).collect(Collectors.toList());
        DashboardEntity dashboardEntity = DashboardEntity.create(ValueReference.of(dashboard.getTitle()), ValueReference.of(dashboard.getDescription()), dashboardWidgets);
        JsonNode data = (JsonNode)this.objectMapper.convertValue((Object)dashboardEntity, JsonNode.class);
        EntityV1 entity = ((EntityV1.Builder)((EntityV1.Builder)EntityV1.builder().id(ModelId.of(dashboard.getId()))).type(ModelTypes.DASHBOARD_V1)).data(data).build();
        return EntityWithConstraints.create(entity);
    }

    private DashboardWidgetEntity encodeWidget(DashboardWidget widget, @Nullable WidgetPosition position) {
        return DashboardWidgetEntity.create(ValueReference.of(widget.getId()), ValueReference.of(widget.getDescription()), ValueReference.of(widget.getType()), ValueReference.of(widget.getCacheTime()), TimeRangeEntity.of(widget.getTimeRange()), ReferenceMapUtils.toReferenceMap(widget.getConfig()), this.encodePosition(position));
    }

    @Nullable
    private DashboardWidgetEntity.Position encodePosition(@Nullable WidgetPosition position) {
        return position == null ? null : DashboardWidgetEntity.Position.create(ValueReference.of(position.width()), ValueReference.of(position.height()), ValueReference.of(position.row()), ValueReference.of(position.col()));
    }

    @Override
    public NativeEntity<Dashboard> createNativeEntity(Entity entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities, String username) {
        if (entity instanceof EntityV1) {
            return this.decode((EntityV1)entity, parameters, nativeEntities, username);
        }
        throw new IllegalArgumentException("Unsupported entity version: " + entity.getClass());
    }

    private NativeEntity<Dashboard> decode(EntityV1 entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities, String username) {
        Dashboard dashboard;
        DashboardEntity dashboardEntity = (DashboardEntity)this.objectMapper.convertValue((Object)entity.data(), DashboardEntity.class);
        try {
            dashboard = this.createDashboard(dashboardEntity.title().asString(parameters), dashboardEntity.description().asString(parameters), dashboardEntity.widgets(), username, parameters, nativeEntities);
        }
        catch (Exception e) {
            throw new ContentPackException("Couldn't create dashboard", e);
        }
        return NativeEntity.create(entity.id(), dashboard.getId(), TYPE_V1, dashboard);
    }

    private Dashboard createDashboard(String title, String description, List<DashboardWidgetEntity> widgets, String username, Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities) throws ValidationException, DashboardWidget.NoSuchWidgetTypeException, InvalidRangeParametersException, InvalidWidgetConfigurationException {
        Dashboard persistedDashboard;
        HashMap<String, Object> dashboardData = new HashMap<String, Object>();
        dashboardData.put("title", title);
        dashboardData.put("description", description);
        dashboardData.put("creator_user_id", username);
        dashboardData.put("created_at", Tools.nowUTC());
        DashboardImpl dashboard = new DashboardImpl(dashboardData);
        String dashboardId = this.dashboardService.save(dashboard);
        ImmutableList.Builder widgetPositions = ImmutableList.builder();
        for (DashboardWidgetEntity widgetEntity : widgets) {
            DashboardWidget widget = this.createDashboardWidget(widgetEntity.id().asString(parameters), widgetEntity.type().asString(parameters), widgetEntity.description().asString(parameters), ReferenceMapUtils.toValueMap(widgetEntity.configuration(), parameters), widgetEntity.cacheTime().asInteger(parameters), username, nativeEntities);
            this.dashboardService.addWidget(dashboard, widget);
            widgetEntity.position().ifPresent(position -> widgetPositions.add((Object)WidgetPositionsRequest.WidgetPosition.create(widget.getId(), position.col().asInteger(parameters), position.row().asInteger(parameters), position.height().asInteger(parameters), position.width().asInteger(parameters))));
        }
        try {
            persistedDashboard = this.dashboardService.load(dashboardId);
            this.dashboardService.updateWidgetPositions(persistedDashboard, WidgetPositionsRequest.create((List<WidgetPositionsRequest.WidgetPosition>)widgetPositions.build()));
        }
        catch (NotFoundException e) {
            throw new RuntimeException("Failed to load dashboard with id " + dashboardId, e);
        }
        return persistedDashboard;
    }

    private DashboardWidget createDashboardWidget(String id, String type, String description, Map<String, Object> configuration, int cacheTime, String username, Map<EntityDescriptor, Object> nativeEntities) throws InvalidRangeParametersException, DashboardWidget.NoSuchWidgetTypeException, InvalidWidgetConfigurationException {
        HashMap<String, Object> widgetConfig = new HashMap<String, Object>(configuration);
        String streamReference = (String)widgetConfig.get("stream_id");
        if (!Strings.isNullOrEmpty((String)streamReference)) {
            EntityDescriptor streamDescriptor = EntityDescriptor.create(streamReference, ModelTypes.STREAM_V1);
            Object stream = nativeEntities.get(streamDescriptor);
            if (stream == null) {
                String msg = "Missing stream for dashboard widget \"" + description + "\": " + streamDescriptor;
                throw new ContentPackException(msg);
            }
            if (stream instanceof Stream) {
                widgetConfig.put("stream_id", ((Stream)stream).getId());
            } else {
                String msg = "Invalid entity type for referenced stream " + streamDescriptor + " for dashboard widget \"" + description + "\": " + stream.getClass();
                throw new ContentPackException(msg);
            }
        }
        Map timerangeConfig = (Map)widgetConfig.get("timerange");
        TimeRange timeRange = this.timeRangeFactory.create(timerangeConfig);
        return this.widgetCreator.buildDashboardWidget(type, id, description, cacheTime, widgetConfig, timeRange, username);
    }

    @Override
    public Optional<NativeEntity<Dashboard>> loadNativeEntity(NativeEntityDescriptor nativeEntityDescriptor) {
        try {
            Dashboard dashboard = this.dashboardService.load(nativeEntityDescriptor.id().id());
            return Optional.of(NativeEntity.create(nativeEntityDescriptor, dashboard));
        }
        catch (NotFoundException e) {
            return Optional.empty();
        }
    }

    @Override
    public void delete(Dashboard nativeEntity) {
        this.dashboardService.destroy(nativeEntity);
    }

    @Override
    public EntityExcerpt createExcerpt(Dashboard dashboard) {
        return ((EntityExcerpt.Builder)((EntityExcerpt.Builder)EntityExcerpt.builder().id(ModelId.of(dashboard.getId()))).type(ModelTypes.DASHBOARD_V1)).title(dashboard.getTitle()).build();
    }

    @Override
    public Set<EntityExcerpt> listEntityExcerpts() {
        return this.dashboardService.all().stream().map(this::createExcerpt).collect(Collectors.toSet());
    }

    @Override
    public Optional<EntityWithConstraints> exportEntity(EntityDescriptor entityDescriptor) {
        ModelId modelId = entityDescriptor.id();
        try {
            Dashboard dashboard = this.dashboardService.load(modelId.id());
            return Optional.of(this.exportNativeEntity(dashboard));
        }
        catch (NotFoundException e) {
            LOG.debug("Couldn't find dashboard {}", (Object)entityDescriptor, (Object)e);
            return Optional.empty();
        }
    }

    @Override
    public Graph<EntityDescriptor> resolveNativeEntity(EntityDescriptor entityDescriptor) {
        MutableGraph mutableGraph = GraphBuilder.directed().build();
        mutableGraph.addNode((Object)entityDescriptor);
        ModelId modelId = entityDescriptor.id();
        try {
            Dashboard dashboard = this.dashboardService.load(modelId.id());
            for (DashboardWidget widget : dashboard.getWidgets().values()) {
                String streamId = (String)widget.getConfig().get("stream_id");
                if (Strings.isNullOrEmpty((String)streamId)) continue;
                LOG.debug("Adding stream <{}> as dependency of widget <{}> on dashboard <{}>", new Object[]{streamId, widget.getId(), dashboard.getId()});
                EntityDescriptor stream = EntityDescriptor.create(streamId, ModelTypes.STREAM_V1);
                mutableGraph.putEdge((Object)entityDescriptor, (Object)stream);
            }
        }
        catch (NotFoundException e) {
            LOG.debug("Couldn't find dashboard {}", (Object)entityDescriptor, (Object)e);
        }
        return ImmutableGraph.copyOf((Graph)mutableGraph);
    }

    @Override
    public Graph<Entity> resolveForInstallation(Entity entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Entity> entities) {
        if (entity instanceof EntityV1) {
            return this.resolveEntityV1((EntityV1)entity, parameters, entities);
        }
        throw new IllegalArgumentException("Unsupported entity version: " + entity.getClass());
    }

    private Graph<Entity> resolveEntityV1(EntityV1 entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Entity> entities) {
        MutableGraph mutableGraph = GraphBuilder.directed().build();
        mutableGraph.addNode((Object)entity);
        DashboardEntity dashboardEntity = (DashboardEntity)this.objectMapper.convertValue((Object)entity.data(), DashboardEntity.class);
        dashboardEntity.widgets().stream().map(widget -> (Reference)widget.configuration().get("stream_id")).filter(ref -> ref instanceof ValueReference).map(ref -> (ValueReference)ref).map(valueReference -> valueReference.asString(parameters)).map(ModelId::of).map(modelId -> EntityDescriptor.create(modelId, ModelTypes.STREAM_V1)).map(entities::get).filter(Objects::nonNull).forEach(stream -> mutableGraph.putEdge((Object)entity, stream));
        return ImmutableGraph.copyOf((Graph)mutableGraph);
    }
}

