/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.facades;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog2.contentpacks.facades.EntityFacade;
import org.graylog2.contentpacks.model.ModelId;
import org.graylog2.contentpacks.model.ModelType;
import org.graylog2.contentpacks.model.ModelTypes;
import org.graylog2.contentpacks.model.constraints.Constraint;
import org.graylog2.contentpacks.model.constraints.PluginVersionConstraint;
import org.graylog2.contentpacks.model.entities.Entity;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.EntityExcerpt;
import org.graylog2.contentpacks.model.entities.EntityV1;
import org.graylog2.contentpacks.model.entities.EntityWithConstraints;
import org.graylog2.contentpacks.model.entities.LookupCacheEntity;
import org.graylog2.contentpacks.model.entities.NativeEntity;
import org.graylog2.contentpacks.model.entities.NativeEntityDescriptor;
import org.graylog2.contentpacks.model.entities.references.ReferenceMapUtils;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.jackson.TypeReferences;
import org.graylog2.lookup.db.DBCacheService;
import org.graylog2.lookup.dto.CacheDto;
import org.graylog2.plugin.PluginMetaData;
import org.graylog2.plugin.lookup.LookupCacheConfiguration;

public class LookupCacheFacade
implements EntityFacade<CacheDto> {
    public static final ModelType TYPE_V1 = ModelTypes.LOOKUP_CACHE_V1;
    private final ObjectMapper objectMapper;
    private final DBCacheService cacheService;
    private final Set<PluginMetaData> pluginMetaData;

    @Inject
    public LookupCacheFacade(ObjectMapper objectMapper, DBCacheService cacheService, Set<PluginMetaData> pluginMetaData) {
        this.objectMapper = objectMapper;
        this.cacheService = cacheService;
        this.pluginMetaData = pluginMetaData;
    }

    @Override
    public EntityWithConstraints exportNativeEntity(CacheDto cacheDto) {
        Map configuration = (Map)this.objectMapper.convertValue((Object)cacheDto.config(), TypeReferences.MAP_STRING_OBJECT);
        LookupCacheEntity lookupCacheEntity = LookupCacheEntity.create(ValueReference.of(cacheDto.name()), ValueReference.of(cacheDto.title()), ValueReference.of(cacheDto.description()), ReferenceMapUtils.toReferenceMap(configuration));
        JsonNode data = (JsonNode)this.objectMapper.convertValue((Object)lookupCacheEntity, JsonNode.class);
        EntityV1 entity = ((EntityV1.Builder)((EntityV1.Builder)EntityV1.builder().id(ModelId.of(cacheDto.id()))).type(ModelTypes.LOOKUP_CACHE_V1)).data(data).build();
        Set<Constraint> constraints = this.versionConstraints(cacheDto);
        return EntityWithConstraints.create(entity, constraints);
    }

    private Set<Constraint> versionConstraints(CacheDto cacheDto) {
        String packageName = cacheDto.config().getClass().getPackage().getName();
        return this.pluginMetaData.stream().filter(metaData -> packageName.startsWith(metaData.getClass().getPackage().getName())).map(PluginVersionConstraint::of).collect(Collectors.toSet());
    }

    @Override
    public NativeEntity<CacheDto> createNativeEntity(Entity entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities, String username) {
        if (entity instanceof EntityV1) {
            return this.decode((EntityV1)entity, parameters);
        }
        throw new IllegalArgumentException("Unsupported entity version: " + entity.getClass());
    }

    private NativeEntity<CacheDto> decode(EntityV1 entity, Map<String, ValueReference> parameters) {
        LookupCacheEntity lookupCacheEntity = (LookupCacheEntity)this.objectMapper.convertValue((Object)entity.data(), LookupCacheEntity.class);
        LookupCacheConfiguration configuration = (LookupCacheConfiguration)this.objectMapper.convertValue(ReferenceMapUtils.toValueMap(lookupCacheEntity.configuration(), parameters), LookupCacheConfiguration.class);
        CacheDto cacheDto = CacheDto.builder().name(lookupCacheEntity.name().asString(parameters)).title(lookupCacheEntity.title().asString(parameters)).description(lookupCacheEntity.description().asString(parameters)).config(configuration).build();
        CacheDto savedCacheDto = this.cacheService.save(cacheDto);
        return NativeEntity.create(entity.id(), savedCacheDto.name(), TYPE_V1, savedCacheDto);
    }

    @Override
    public Optional<NativeEntity<CacheDto>> findExisting(Entity entity, Map<String, ValueReference> parameters) {
        if (entity instanceof EntityV1) {
            return this.findExisting((EntityV1)entity, parameters);
        }
        throw new IllegalArgumentException("Unsupported entity version: " + entity.getClass());
    }

    private Optional<NativeEntity<CacheDto>> findExisting(EntityV1 entity, Map<String, ValueReference> parameters) {
        LookupCacheEntity cacheEntity = (LookupCacheEntity)this.objectMapper.convertValue((Object)entity.data(), LookupCacheEntity.class);
        String name = cacheEntity.name().asString(parameters);
        Optional<CacheDto> existingCache = this.cacheService.get(name);
        return existingCache.map(cache -> NativeEntity.create(entity.id(), cache.id(), TYPE_V1, cache));
    }

    @Override
    public Optional<NativeEntity<CacheDto>> loadNativeEntity(NativeEntityDescriptor nativeEntityDescriptor) {
        return this.cacheService.get(nativeEntityDescriptor.id().id()).map(entity -> NativeEntity.create(nativeEntityDescriptor, entity));
    }

    @Override
    public void delete(CacheDto nativeEntity) {
        this.cacheService.delete(nativeEntity.id());
    }

    @Override
    public EntityExcerpt createExcerpt(CacheDto cacheDto) {
        return ((EntityExcerpt.Builder)((EntityExcerpt.Builder)EntityExcerpt.builder().id(ModelId.of(cacheDto.name()))).type(ModelTypes.LOOKUP_CACHE_V1)).title(cacheDto.title()).build();
    }

    @Override
    public Set<EntityExcerpt> listEntityExcerpts() {
        return this.cacheService.findAll().stream().map(this::createExcerpt).collect(Collectors.toSet());
    }

    @Override
    public Optional<EntityWithConstraints> exportEntity(EntityDescriptor entityDescriptor) {
        ModelId modelId = entityDescriptor.id();
        return this.cacheService.get(modelId.id()).map(this::exportNativeEntity);
    }
}

