/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.AsWrapperTypeDeserializer;
import java.io.IOException;

public class AsValueReferenceTypeDeserializer
extends AsWrapperTypeDeserializer {
    public AsValueReferenceTypeDeserializer(JavaType bt, TypeIdResolver idRes, String typePropertyName, boolean typeIdVisible, JavaType defaultImpl) {
        super(bt, idRes, typePropertyName, typeIdVisible, defaultImpl);
    }

    protected AsValueReferenceTypeDeserializer(AsWrapperTypeDeserializer src, BeanProperty property) {
        super(src, property);
    }

    public TypeDeserializer forProperty(BeanProperty prop) {
        return prop == this._property ? this : new AsValueReferenceTypeDeserializer(this, prop);
    }

    protected Object _deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        TreeNode valueNode;
        TreeNode treeNode = p.readValueAsTree();
        TreeNode typeNode = treeNode.path("type");
        if (!typeNode.isObject()) {
            ctxt.reportWrongTokenException(typeNode.traverse(), JsonToken.START_OBJECT, "expected START_OBJECT before the type information and deserialized value", new Object[0]);
        }
        if (!(valueNode = typeNode.path("value")).isValueNode()) {
            ctxt.reportWrongTokenException(typeNode.traverse(), JsonToken.VALUE_STRING, "expected VALUE_STRING as type information and deserialized value", new Object[0]);
        }
        JsonParser jsonParser = valueNode.traverse();
        String typeId = jsonParser.nextTextValue();
        JsonDeserializer deser = this._findDeserializer(ctxt, typeId);
        JsonParser newParser = treeNode.traverse();
        if (newParser.nextToken() != JsonToken.START_OBJECT) {
            ctxt.reportWrongTokenException(newParser, JsonToken.START_OBJECT, "expected START_OBJECT", new Object[0]);
        }
        return deser.deserialize(newParser, ctxt);
    }
}

