/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.model.entities.references;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.graylog2.contentpacks.model.entities.references.AutoValue_ValueReference;
import org.graylog2.contentpacks.model.entities.references.Reference;
import org.graylog2.contentpacks.model.entities.references.ValueType;
import org.graylog2.contentpacks.model.entities.references.ValueTyped;

@JsonAutoDetect
@JsonDeserialize(builder=AutoValue_ValueReference.Builder.class)
@AutoValue
public abstract class ValueReference
implements ValueTyped,
Reference {
    public static final String FIELD_VALUE = "value";

    @JsonProperty(value="value")
    public abstract Object value();

    public Boolean asBoolean(Map<String, ValueReference> parameters) {
        switch (this.valueType()) {
            case BOOLEAN: {
                return (Boolean)Boolean.class.cast(this.value());
            }
            case PARAMETER: {
                return this.asType(parameters, Boolean.class);
            }
        }
        throw new IllegalStateException("Expected value reference of type BOOLEAN but got " + (Object)((Object)this.valueType()));
    }

    public Double asDouble(Map<String, ValueReference> parameters) {
        switch (this.valueType()) {
            case DOUBLE: {
                return (Double)Double.class.cast(this.value());
            }
            case PARAMETER: {
                return this.asType(parameters, Double.class);
            }
        }
        throw new IllegalStateException("Expected value reference of type DOUBLE but got " + (Object)((Object)this.valueType()));
    }

    public Float asFloat(Map<String, ValueReference> parameters) {
        switch (this.valueType()) {
            case FLOAT: {
                return (Float)Float.class.cast(this.value());
            }
            case PARAMETER: {
                return this.asType(parameters, Float.class);
            }
        }
        throw new IllegalStateException("Expected value reference of type FLOAT but got " + (Object)((Object)this.valueType()));
    }

    public Integer asInteger(Map<String, ValueReference> parameters) {
        switch (this.valueType()) {
            case INTEGER: {
                return (Integer)Integer.class.cast(this.value());
            }
            case PARAMETER: {
                return this.asType(parameters, Integer.class);
            }
        }
        throw new IllegalStateException("Expected value reference of type INTEGER but got " + (Object)((Object)this.valueType()));
    }

    public Long asLong(Map<String, ValueReference> parameters) {
        switch (this.valueType()) {
            case LONG: {
                return (Long)Long.class.cast(this.value());
            }
            case PARAMETER: {
                return this.asType(parameters, Long.class);
            }
        }
        throw new IllegalStateException("Expected value reference of type LONG but got " + (Object)((Object)this.valueType()));
    }

    public String asString(Map<String, ValueReference> parameters) {
        switch (this.valueType()) {
            case STRING: {
                return (String)String.class.cast(this.value());
            }
            case PARAMETER: {
                return this.asType(parameters, String.class);
            }
        }
        throw new IllegalStateException("Expected value reference of type STRING but got " + (Object)((Object)this.valueType()));
    }

    public String asString() {
        switch (this.valueType()) {
            case STRING: {
                return (String)String.class.cast(this.value());
            }
        }
        throw new IllegalStateException("Expected value reference of type STRING but got " + (Object)((Object)this.valueType()));
    }

    private <S> S asType(Map<String, ValueReference> parameters, Class<S> type) {
        if (this.valueType() == ValueType.PARAMETER) {
            String value = (String)String.class.cast(this.value());
            ValueReference filledParameter = parameters.get(value);
            if (filledParameter.valueType().targetClass().equals(type)) {
                return type.cast(filledParameter.value());
            }
            throw new IllegalStateException("Expected parameter reference for Java type " + type + " but got " + (Object)((Object)filledParameter.valueType()));
        }
        throw new IllegalStateException("Expected value reference of type PARAMETER but got " + (Object)((Object)this.valueType()));
    }

    public <S extends Enum<S>> S asEnum(Map<String, ValueReference> parameters, Class<S> type) {
        String value;
        switch (this.valueType()) {
            case STRING: {
                value = (String)String.class.cast(this.value());
                break;
            }
            case PARAMETER: {
                value = this.asType(parameters, String.class);
                break;
            }
            default: {
                throw new IllegalStateException("Expected value reference of type STRING or PARAMETER but got " + (Object)((Object)this.valueType()));
            }
        }
        return Enum.valueOf(type, value);
    }

    @Nullable
    public static ValueReference of(Object value) {
        if (value instanceof Boolean) {
            return ValueReference.of((Boolean)value);
        }
        if (value instanceof Double) {
            return ValueReference.of((Double)value);
        }
        if (value instanceof Float) {
            return ValueReference.of((Float)value);
        }
        if (value instanceof Integer) {
            return ValueReference.of((Integer)value);
        }
        if (value instanceof Long) {
            return ValueReference.of((Long)value);
        }
        if (value instanceof String) {
            return ValueReference.of((String)value);
        }
        if (value instanceof Enum) {
            return ValueReference.of((Enum)value);
        }
        return null;
    }

    public static ValueReference of(Boolean value) {
        return ((Builder)ValueReference.builder().valueType(ValueType.BOOLEAN)).value(value).build();
    }

    public static ValueReference of(Double value) {
        return ((Builder)ValueReference.builder().valueType(ValueType.DOUBLE)).value(value).build();
    }

    public static ValueReference of(Float value) {
        return ((Builder)ValueReference.builder().valueType(ValueType.FLOAT)).value(value).build();
    }

    public static ValueReference of(Integer value) {
        return ((Builder)ValueReference.builder().valueType(ValueType.INTEGER)).value(value).build();
    }

    public static ValueReference of(Long value) {
        return ((Builder)ValueReference.builder().valueType(ValueType.LONG)).value(value).build();
    }

    public static ValueReference of(String value) {
        return ((Builder)ValueReference.builder().valueType(ValueType.STRING)).value(value).build();
    }

    public static ValueReference of(Enum value) {
        return ((Builder)ValueReference.builder().valueType(ValueType.STRING)).value(value.name()).build();
    }

    public static ValueReference createParameter(String value) {
        return ((Builder)ValueReference.builder().valueType(ValueType.PARAMETER)).value(value).build();
    }

    public static Builder builder() {
        return new AutoValue_ValueReference.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder
    implements ValueTyped.TypeBuilder<Builder> {
        @JsonProperty(value="value")
        public abstract Builder value(Object var1);

        abstract ValueReference autoBuild();

        public ValueReference build() {
            boolean isParameter;
            ValueReference valueReference = this.autoBuild();
            boolean bl = isParameter = valueReference.valueType() == ValueType.PARAMETER;
            if (isParameter) {
                String value = (String)valueReference.value();
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)value), (Object)"Parameter must not be blank");
            }
            return valueReference;
        }
    }
}

