/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.model.parameters;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import org.graylog2.contentpacks.model.entities.references.ValueType;
import org.graylog2.contentpacks.model.parameters.StringParameter;

final class AutoValue_StringParameter
extends StringParameter {
    private final ValueType valueType;
    private final String name;
    private final String title;
    private final String description;
    private final Optional<String> defaultValue;

    private AutoValue_StringParameter(ValueType valueType, String name, String title, String description, Optional<String> defaultValue) {
        this.valueType = valueType;
        this.name = name;
        this.title = title;
        this.description = description;
        this.defaultValue = defaultValue;
    }

    @Override
    @JsonProperty(value="type")
    public ValueType valueType() {
        return this.valueType;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="title")
    public String title() {
        return this.title;
    }

    @Override
    @JsonProperty(value="description")
    public String description() {
        return this.description;
    }

    @Override
    @JsonProperty(value="default_value")
    public Optional<String> defaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return "StringParameter{valueType=" + (Object)((Object)this.valueType) + ", name=" + this.name + ", title=" + this.title + ", description=" + this.description + ", defaultValue=" + this.defaultValue + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof StringParameter) {
            StringParameter that = (StringParameter)o;
            return this.valueType.equals((Object)that.valueType()) && this.name.equals(that.name()) && this.title.equals(that.title()) && this.description.equals(that.description()) && this.defaultValue.equals(that.defaultValue());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.valueType.hashCode();
        h$ *= 1000003;
        h$ ^= this.name.hashCode();
        h$ *= 1000003;
        h$ ^= this.title.hashCode();
        h$ *= 1000003;
        h$ ^= this.description.hashCode();
        h$ *= 1000003;
        return h$ ^= this.defaultValue.hashCode();
    }

    static final class Builder
    extends StringParameter.Builder {
        private ValueType valueType;
        private String name;
        private String title;
        private String description;
        private Optional<String> defaultValue = Optional.empty();

        Builder() {
        }

        @Override
        public StringParameter.Builder valueType(ValueType valueType) {
            if (valueType == null) {
                throw new NullPointerException("Null valueType");
            }
            this.valueType = valueType;
            return this;
        }

        @Override
        public StringParameter.Builder name(String name) {
            if (name == null) {
                throw new NullPointerException("Null name");
            }
            this.name = name;
            return this;
        }

        @Override
        public StringParameter.Builder title(String title) {
            if (title == null) {
                throw new NullPointerException("Null title");
            }
            this.title = title;
            return this;
        }

        @Override
        public StringParameter.Builder description(String description) {
            if (description == null) {
                throw new NullPointerException("Null description");
            }
            this.description = description;
            return this;
        }

        @Override
        public StringParameter.Builder defaultValue(Optional defaultValue) {
            if (defaultValue == null) {
                throw new NullPointerException("Null defaultValue");
            }
            this.defaultValue = defaultValue;
            return this;
        }

        @Override
        StringParameter autoBuild() {
            String missing = "";
            if (this.valueType == null) {
                missing = missing + " valueType";
            }
            if (this.name == null) {
                missing = missing + " name";
            }
            if (this.title == null) {
                missing = missing + " title";
            }
            if (this.description == null) {
                missing = missing + " description";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_StringParameter(this.valueType, this.name, this.title, this.description, this.defaultValue);
        }
    }
}

