/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.types.ObjectId;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedList;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;

public abstract class PaginatedDbService<DTO> {
    protected final JacksonDBCollection<DTO, ObjectId> db;

    protected PaginatedDbService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, Class<DTO> dtoClass, String collectionName) {
        this.db = JacksonDBCollection.wrap((DBCollection)mongoConnection.getDatabase().getCollection(collectionName), dtoClass, ObjectId.class, (ObjectMapper)mapper.get());
    }

    public Optional<DTO> get(String id) {
        return Optional.ofNullable(this.db.findOneById((Object)new ObjectId(id)));
    }

    public DTO save(DTO dto) {
        WriteResult save = this.db.save(dto);
        return (DTO)save.getSavedObject();
    }

    public int delete(String id) {
        return this.db.removeById((Object)new ObjectId(id)).getN();
    }

    protected PaginatedList<DTO> findPaginatedWithQueryAndSort(DBQuery.Query query, DBSort.SortBuilder sort, int page, int perPage) {
        try (DBCursor cursor = this.db.find(query).sort((DBObject)sort).limit(perPage).skip(perPage * Math.max(0, page - 1));){
            PaginatedList<DTO> paginatedList = new PaginatedList<DTO>(this.asImmutableList((Iterator<? extends DTO>)cursor), cursor.count(), page, perPage);
            return paginatedList;
        }
    }

    private ImmutableList<DTO> asImmutableList(Iterator<? extends DTO> cursor) {
        return ImmutableList.copyOf(cursor);
    }

    protected PaginatedList<DTO> findPaginatedWithQueryFilterAndSort(DBQuery.Query query, Predicate<DTO> filter, DBSort.SortBuilder sort, int page, int perPage) {
        AtomicInteger total = new AtomicInteger(0);
        try (Stream<DTO> cursor = this.streamQueryWithSort(query, sort);){
            Stream<Object> dtoStream = cursor.filter(filter).peek(dto -> total.incrementAndGet());
            List list = Stream.of(dtoStream).flatMap(stream -> stream).skip(perPage * Math.max(0, page - 1)).limit(perPage).collect(Collectors.toList());
            PaginatedList paginatedList = new PaginatedList(list, total.get(), page, perPage);
            return paginatedList;
        }
    }

    public Stream<DTO> streamAll() {
        return this.streamQuery(DBQuery.empty());
    }

    public Stream<DTO> streamByIds(Set<String> idSet) {
        List objectIds = idSet.stream().map(ObjectId::new).collect(Collectors.toList());
        return this.streamQuery(DBQuery.in((String)"_id", objectIds));
    }

    protected Stream<DTO> streamQuery(DBQuery.Query query) {
        DBCursor cursor = this.db.find(query);
        return (Stream)Streams.stream((Iterable)cursor).onClose(() -> ((DBCursor)cursor).close());
    }

    protected Stream<DTO> streamQueryWithSort(DBQuery.Query query, DBSort.SortBuilder sort) {
        DBCursor cursor = this.db.find(query).sort((DBObject)sort);
        return (Stream)Streams.stream((Iterable)cursor).onClose(() -> ((DBCursor)cursor).close());
    }

    protected DBSort.SortBuilder getSortBuilder(String order, String field) {
        DBSort.SortBuilder sortBuilder = "desc".equalsIgnoreCase(order) ? DBSort.desc((String)field) : DBSort.asc((String)field);
        return sortBuilder;
    }
}

