/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.decorators;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.inject.assistedinject.Assisted;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog2.decorators.Decorator;
import org.graylog2.lookup.LookupTableService;
import org.graylog2.lookup.db.DBLookupTableService;
import org.graylog2.lookup.dto.LookupTableDto;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.DropdownField;
import org.graylog2.plugin.configuration.fields.TextField;
import org.graylog2.plugin.decorators.SearchResponseDecorator;
import org.graylog2.plugin.lookup.LookupResult;
import org.graylog2.rest.models.messages.responses.ResultMessageSummary;
import org.graylog2.rest.resources.search.responses.SearchResponse;

public class LookupTableDecorator
implements SearchResponseDecorator {
    private static final String CK_SOURCE_FIELD = "source_field";
    private static final String CK_TARGET_FIELD = "target_field";
    private static final String CK_LOOKUP_TABLE_NAME = "lookup_table_name";
    private final String sourceField;
    private final String targetField;
    private final LookupTableService.Function lookupTable;

    @Inject
    public LookupTableDecorator(@Assisted Decorator decorator, LookupTableService lookupTableService) {
        String sourceField = (String)decorator.config().get(CK_SOURCE_FIELD);
        String targetField = (String)decorator.config().get(CK_TARGET_FIELD);
        String lookupTableName = (String)decorator.config().get(CK_LOOKUP_TABLE_NAME);
        if (Strings.isNullOrEmpty((String)sourceField)) {
            throw new IllegalStateException("Missing configuration field: source_field");
        }
        if (Strings.isNullOrEmpty((String)targetField)) {
            throw new IllegalStateException("Missing configuration field: target_field");
        }
        if (Strings.isNullOrEmpty((String)lookupTableName)) {
            throw new IllegalStateException("Missing configuration field: lookup_table_name");
        }
        if (!lookupTableService.hasTable(lookupTableName)) {
            throw new IllegalStateException("Configured lookup table <" + lookupTableName + "> doesn't exist");
        }
        this.sourceField = sourceField;
        this.targetField = targetField;
        this.lookupTable = lookupTableService.newBuilder().lookupTable(lookupTableName).build();
    }

    @Override
    public SearchResponse apply(SearchResponse searchResponse) {
        List<ResultMessageSummary> summaries = searchResponse.messages().stream().map(summary -> {
            if (!summary.message().containsKey(this.sourceField)) {
                return summary;
            }
            LookupResult result = this.lookupTable.lookup(summary.message().get(this.sourceField));
            if (result == null || result.isEmpty()) {
                return summary;
            }
            Message message = new Message((Map<String, Object>)ImmutableMap.copyOf(summary.message()));
            message.addField(this.targetField, result.singleValue());
            return summary.toBuilder().message(message.getFields()).build();
        }).collect(Collectors.toList());
        return searchResponse.toBuilder().messages(summaries).build();
    }

    public static class Descriptor
    extends SearchResponseDecorator.Descriptor {
        public Descriptor() {
            super("Lookup Table", "http://docs.graylog.org/", "Lookup Table Decorator");
        }
    }

    public static class Config
    implements SearchResponseDecorator.Config {
        private final DBLookupTableService lookupTableService;

        @Inject
        public Config(DBLookupTableService lookupTableService) {
            this.lookupTableService = lookupTableService;
        }

        @Override
        public ConfigurationRequest getRequestedConfiguration() {
            final Map<String, String> lookupTables = this.lookupTableService.findAll().stream().collect(Collectors.toMap(LookupTableDto::name, LookupTableDto::title));
            return new ConfigurationRequest(){
                {
                    this.addField(new TextField(LookupTableDecorator.CK_SOURCE_FIELD, "Source field", "", "The message field which includes the value to look up.", ConfigurationField.Optional.NOT_OPTIONAL));
                    this.addField(new TextField(LookupTableDecorator.CK_TARGET_FIELD, "Target field", "", "The message field that will be created with the result of the lookup.", ConfigurationField.Optional.NOT_OPTIONAL));
                    this.addField(new DropdownField(LookupTableDecorator.CK_LOOKUP_TABLE_NAME, "Lookup table", "", lookupTables, "The lookup table to use.", ConfigurationField.Optional.NOT_OPTIONAL));
                }
            };
        }
    }

    public static interface Factory
    extends SearchResponseDecorator.Factory {
        @Override
        public LookupTableDecorator create(Decorator var1);

        @Override
        public Config getConfig();

        @Override
        public Descriptor getDescriptor();
    }
}

