/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.grok;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.krakens.grok.api.Grok;
import io.krakens.grok.api.GrokCompiler;
import io.krakens.grok.api.exception.GrokException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog2.database.NotFoundException;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.grok.GrokPattern;
import org.graylog2.grok.GrokPatternService;
import org.graylog2.grok.GrokPatternsDeletedEvent;
import org.graylog2.grok.GrokPatternsUpdatedEvent;
import org.graylog2.plugin.database.ValidationException;

public class InMemoryGrokPatternService
implements GrokPatternService {
    private final AtomicLong idGen = new AtomicLong(0L);
    private final ConcurrentMap<String, GrokPattern> store = new ConcurrentHashMap<String, GrokPattern>();
    private final ClusterEventBus clusterBus;

    @Inject
    public InMemoryGrokPatternService(ClusterEventBus clusterBus) {
        this.clusterBus = clusterBus;
    }

    @Override
    public GrokPattern load(String patternId) throws NotFoundException {
        GrokPattern pattern = (GrokPattern)this.store.get(patternId);
        if (pattern == null) {
            throw new NotFoundException("Couldn't find Grok pattern with ID " + patternId);
        }
        return pattern;
    }

    @Override
    public Optional<GrokPattern> loadByName(String name) {
        return this.store.values().stream().filter(pattern -> pattern.name().equals(name)).findAny();
    }

    @Override
    public Set<GrokPattern> bulkLoad(Collection<String> patternIds) {
        return patternIds.stream().map(this.store::get).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public Set<GrokPattern> loadAll() {
        return Sets.newHashSet(this.store.values());
    }

    @Override
    public GrokPattern save(GrokPattern pattern) throws ValidationException {
        try {
            if (!this.validate(pattern)) {
                throw new ValidationException("Pattern " + pattern.name() + " invalid.");
            }
        }
        catch (GrokException | PatternSyntaxException e) {
            throw new ValidationException("Invalid pattern " + pattern + "\n" + e.getMessage());
        }
        GrokPattern toSave = pattern.id() == null ? pattern.toBuilder().id(this.createId()).build() : pattern;
        this.store.put(toSave.id(), toSave);
        this.clusterBus.post(GrokPatternsUpdatedEvent.create((Set<String>)ImmutableSet.of((Object)toSave.name())));
        return toSave;
    }

    private GrokPattern uncheckedSave(GrokPattern pattern) {
        try {
            return this.save(pattern);
        }
        catch (ValidationException e) {
            return null;
        }
    }

    @Override
    public List<GrokPattern> saveAll(Collection<GrokPattern> patterns, boolean replace) throws ValidationException {
        List<GrokPattern> grokPatterns;
        Set<String> patternNames;
        try {
            if (!this.validateAll(patterns)) {
                throw new ValidationException("Patterns invalid.");
            }
        }
        catch (GrokException | PatternSyntaxException e) {
            throw new ValidationException("Invalid patterns.\n" + e.getMessage());
        }
        if (replace) {
            this.deleteAll();
        }
        if (!(patternNames = (grokPatterns = patterns.stream().map(this::uncheckedSave).collect(Collectors.toList())).stream().map(GrokPattern::name).collect(Collectors.toSet())).isEmpty()) {
            this.clusterBus.post(GrokPatternsUpdatedEvent.create(patternNames));
        }
        return grokPatterns;
    }

    @Override
    public Map<String, Object> match(GrokPattern pattern, String sampleData) throws GrokException {
        Set<GrokPattern> patterns = this.loadAll();
        GrokCompiler grokCompiler = GrokCompiler.newInstance();
        for (GrokPattern storedPattern : patterns) {
            grokCompiler.register(storedPattern.name(), storedPattern.pattern());
        }
        grokCompiler.register(pattern.name(), pattern.pattern());
        Grok grok = grokCompiler.compile("%{" + pattern.name() + "}");
        return grok.capture(sampleData);
    }

    @Override
    public boolean validate(GrokPattern pattern) throws GrokException {
        Set<GrokPattern> patterns = this.loadAll();
        boolean fieldsMissing = Strings.isNullOrEmpty((String)pattern.name()) || Strings.isNullOrEmpty((String)pattern.pattern());
        GrokCompiler grokCompiler = GrokCompiler.newInstance();
        for (GrokPattern storedPattern : patterns) {
            grokCompiler.register(storedPattern.name(), storedPattern.pattern());
        }
        grokCompiler.register(pattern.name(), pattern.pattern());
        grokCompiler.compile("%{" + pattern.name() + "}");
        return !fieldsMissing;
    }

    @Override
    public boolean validateAll(Collection<GrokPattern> newPatterns) throws GrokException {
        Set<GrokPattern> patterns = this.loadAll();
        GrokCompiler grokCompiler = GrokCompiler.newInstance();
        for (GrokPattern newPattern : newPatterns) {
            boolean fieldsMissing;
            boolean bl = fieldsMissing = Strings.isNullOrEmpty((String)newPattern.name()) || Strings.isNullOrEmpty((String)newPattern.pattern());
            if (fieldsMissing) {
                return false;
            }
            grokCompiler.register(newPattern.name(), newPattern.pattern());
        }
        for (GrokPattern storedPattern : patterns) {
            grokCompiler.register(storedPattern.name(), storedPattern.pattern());
        }
        for (GrokPattern newPattern : newPatterns) {
            grokCompiler.compile("%{" + newPattern.name() + "}");
        }
        return true;
    }

    @Override
    public int delete(String patternId) {
        GrokPattern grokPattern = (GrokPattern)this.store.remove(patternId);
        if (grokPattern != null) {
            this.clusterBus.post(GrokPatternsDeletedEvent.create((Set<String>)ImmutableSet.of((Object)grokPattern.name())));
        }
        return grokPattern == null ? 0 : 1;
    }

    @Override
    public int deleteAll() {
        Set<String> patternNames = this.store.values().stream().map(GrokPattern::name).collect(Collectors.toSet());
        if (!patternNames.isEmpty()) {
            this.store.clear();
            this.clusterBus.post(GrokPatternsDeletedEvent.create(patternNames));
        }
        return patternNames.size();
    }

    private String createId() {
        return String.valueOf(this.idGen.incrementAndGet());
    }
}

