/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.graylog2.indexer.IndexSet;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

public class IndexHelper {
    public static Set<String> getOldestIndices(IndexSet indexSet, int count) {
        String[] managedIndicesNames = indexSet.getManagedIndices();
        if (count <= 0 || managedIndicesNames.length <= count) {
            return Collections.emptySet();
        }
        ArrayList numbers = new ArrayList(managedIndicesNames.length);
        for (String indexName : managedIndicesNames) {
            indexSet.extractIndexNumber(indexName).ifPresent(numbers::add);
        }
        List<String> sorted = IndexHelper.prependPrefixes(indexSet.getIndexPrefix(), Tools.asSortedSet(numbers));
        return ImmutableSet.copyOf(sorted.subList(0, count));
    }

    @Nullable
    public static QueryBuilder getTimestampRangeFilter(TimeRange range) {
        if (range == null) {
            return null;
        }
        return QueryBuilders.rangeQuery((String)"timestamp").gte((Object)Tools.buildElasticSearchTimeFormat(range.getFrom())).lte((Object)Tools.buildElasticSearchTimeFormat(range.getTo()));
    }

    private static List<String> prependPrefixes(String prefix, Collection<Integer> numbers) {
        ArrayList<String> r = new ArrayList<String>();
        for (int number : numbers) {
            r.add(prefix + "_" + number);
        }
        return r;
    }
}

