/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.indexset;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.ZonedDateTime;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.graylog2.indexer.indexset.AutoValue_IndexSetConfig;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.plugin.indexer.retention.RetentionStrategyConfig;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;
import org.joda.time.Duration;
import org.mongojack.Id;
import org.mongojack.ObjectId;

abstract class $AutoValue_IndexSetConfig
extends IndexSetConfig {
    private final String id;
    @NotBlank
    private final String title;
    private final String description;
    private final boolean isWritable;
    @NotBlank
    @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$")
    private final @NotBlank @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$") String indexPrefix;
    private final String indexMatchPattern;
    private final String indexWildcard;
    @Min(value=1L)
    private final @Min(value=1L) int shards;
    @Min(value=0L)
    private final @Min(value=0L) int replicas;
    private final String rotationStrategyClass;
    @NotNull
    private final RotationStrategyConfig rotationStrategy;
    private final String retentionStrategyClass;
    @NotNull
    private final RetentionStrategyConfig retentionStrategy;
    @NotNull
    private final ZonedDateTime creationDate;
    @NotBlank
    private final String indexAnalyzer;
    @NotBlank
    private final String indexTemplateName;
    @Min(value=1L)
    private final @Min(value=1L) int indexOptimizationMaxNumSegments;
    private final boolean indexOptimizationDisabled;
    private final Duration fieldTypeRefreshInterval;

    $AutoValue_IndexSetConfig(@Nullable String id, @NotBlank String title, @Nullable String description, boolean isWritable, @NotBlank @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$") @NotBlank @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$") String indexPrefix, @Nullable String indexMatchPattern, @Nullable String indexWildcard, @Min(value=1L) @Min(value=1L) int shards, @Min(value=0L) @Min(value=0L) int replicas, @Nullable String rotationStrategyClass, @NotNull RotationStrategyConfig rotationStrategy, @Nullable String retentionStrategyClass, @NotNull RetentionStrategyConfig retentionStrategy, @NotNull ZonedDateTime creationDate, @NotBlank String indexAnalyzer, @NotBlank String indexTemplateName, @Min(value=1L) @Min(value=1L) int indexOptimizationMaxNumSegments, boolean indexOptimizationDisabled, Duration fieldTypeRefreshInterval) {
        this.id = id;
        if (title == null) {
            throw new NullPointerException("Null title");
        }
        this.title = title;
        this.description = description;
        this.isWritable = isWritable;
        if (indexPrefix == null) {
            throw new NullPointerException("Null indexPrefix");
        }
        this.indexPrefix = indexPrefix;
        this.indexMatchPattern = indexMatchPattern;
        this.indexWildcard = indexWildcard;
        this.shards = shards;
        this.replicas = replicas;
        this.rotationStrategyClass = rotationStrategyClass;
        if (rotationStrategy == null) {
            throw new NullPointerException("Null rotationStrategy");
        }
        this.rotationStrategy = rotationStrategy;
        this.retentionStrategyClass = retentionStrategyClass;
        if (retentionStrategy == null) {
            throw new NullPointerException("Null retentionStrategy");
        }
        this.retentionStrategy = retentionStrategy;
        if (creationDate == null) {
            throw new NullPointerException("Null creationDate");
        }
        this.creationDate = creationDate;
        if (indexAnalyzer == null) {
            throw new NullPointerException("Null indexAnalyzer");
        }
        this.indexAnalyzer = indexAnalyzer;
        if (indexTemplateName == null) {
            throw new NullPointerException("Null indexTemplateName");
        }
        this.indexTemplateName = indexTemplateName;
        this.indexOptimizationMaxNumSegments = indexOptimizationMaxNumSegments;
        this.indexOptimizationDisabled = indexOptimizationDisabled;
        if (fieldTypeRefreshInterval == null) {
            throw new NullPointerException("Null fieldTypeRefreshInterval");
        }
        this.fieldTypeRefreshInterval = fieldTypeRefreshInterval;
    }

    @Override
    @JsonProperty(value="id")
    @Nullable
    @Id
    @ObjectId
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="title")
    @NotBlank
    public String title() {
        return this.title;
    }

    @Override
    @JsonProperty(value="description")
    @Nullable
    public String description() {
        return this.description;
    }

    @Override
    @JsonProperty(value="writable")
    public boolean isWritable() {
        return this.isWritable;
    }

    @Override
    @JsonProperty(value="index_prefix")
    @NotBlank
    @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$")
    public @NotBlank @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$") String indexPrefix() {
        return this.indexPrefix;
    }

    @Override
    @JsonProperty(value="index_match_pattern")
    @Nullable
    public String indexMatchPattern() {
        return this.indexMatchPattern;
    }

    @Override
    @JsonProperty(value="index_wildcard")
    @Nullable
    public String indexWildcard() {
        return this.indexWildcard;
    }

    @Override
    @JsonProperty(value="shards")
    @Min(value=1L)
    public @Min(value=1L) int shards() {
        return this.shards;
    }

    @Override
    @JsonProperty(value="replicas")
    @Min(value=0L)
    public @Min(value=0L) int replicas() {
        return this.replicas;
    }

    @Override
    @JsonProperty(value="rotation_strategy_class")
    @Nullable
    public String rotationStrategyClass() {
        return this.rotationStrategyClass;
    }

    @Override
    @JsonProperty(value="rotation_strategy")
    @NotNull
    public RotationStrategyConfig rotationStrategy() {
        return this.rotationStrategy;
    }

    @Override
    @JsonProperty(value="retention_strategy_class")
    @Nullable
    public String retentionStrategyClass() {
        return this.retentionStrategyClass;
    }

    @Override
    @JsonProperty(value="retention_strategy")
    @NotNull
    public RetentionStrategyConfig retentionStrategy() {
        return this.retentionStrategy;
    }

    @Override
    @JsonProperty(value="creation_date")
    @NotNull
    public ZonedDateTime creationDate() {
        return this.creationDate;
    }

    @Override
    @JsonProperty(value="index_analyzer")
    @NotBlank
    public String indexAnalyzer() {
        return this.indexAnalyzer;
    }

    @Override
    @JsonProperty(value="index_template_name")
    @NotBlank
    public String indexTemplateName() {
        return this.indexTemplateName;
    }

    @Override
    @JsonProperty(value="index_optimization_max_num_segments")
    @Min(value=1L)
    public @Min(value=1L) int indexOptimizationMaxNumSegments() {
        return this.indexOptimizationMaxNumSegments;
    }

    @Override
    @JsonProperty(value="index_optimization_disabled")
    public boolean indexOptimizationDisabled() {
        return this.indexOptimizationDisabled;
    }

    @Override
    @JsonProperty(value="field_type_refresh_interval")
    public Duration fieldTypeRefreshInterval() {
        return this.fieldTypeRefreshInterval;
    }

    public String toString() {
        return "IndexSetConfig{id=" + this.id + ", title=" + this.title + ", description=" + this.description + ", isWritable=" + this.isWritable + ", indexPrefix=" + this.indexPrefix + ", indexMatchPattern=" + this.indexMatchPattern + ", indexWildcard=" + this.indexWildcard + ", shards=" + this.shards + ", replicas=" + this.replicas + ", rotationStrategyClass=" + this.rotationStrategyClass + ", rotationStrategy=" + this.rotationStrategy + ", retentionStrategyClass=" + this.retentionStrategyClass + ", retentionStrategy=" + this.retentionStrategy + ", creationDate=" + this.creationDate + ", indexAnalyzer=" + this.indexAnalyzer + ", indexTemplateName=" + this.indexTemplateName + ", indexOptimizationMaxNumSegments=" + this.indexOptimizationMaxNumSegments + ", indexOptimizationDisabled=" + this.indexOptimizationDisabled + ", fieldTypeRefreshInterval=" + this.fieldTypeRefreshInterval + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IndexSetConfig) {
            IndexSetConfig that = (IndexSetConfig)o;
            return (this.id == null ? that.id() == null : this.id.equals(that.id())) && this.title.equals(that.title()) && (this.description == null ? that.description() == null : this.description.equals(that.description())) && this.isWritable == that.isWritable() && this.indexPrefix.equals(that.indexPrefix()) && (this.indexMatchPattern == null ? that.indexMatchPattern() == null : this.indexMatchPattern.equals(that.indexMatchPattern())) && (this.indexWildcard == null ? that.indexWildcard() == null : this.indexWildcard.equals(that.indexWildcard())) && this.shards == that.shards() && this.replicas == that.replicas() && (this.rotationStrategyClass == null ? that.rotationStrategyClass() == null : this.rotationStrategyClass.equals(that.rotationStrategyClass())) && this.rotationStrategy.equals(that.rotationStrategy()) && (this.retentionStrategyClass == null ? that.retentionStrategyClass() == null : this.retentionStrategyClass.equals(that.retentionStrategyClass())) && this.retentionStrategy.equals(that.retentionStrategy()) && this.creationDate.equals(that.creationDate()) && this.indexAnalyzer.equals(that.indexAnalyzer()) && this.indexTemplateName.equals(that.indexTemplateName()) && this.indexOptimizationMaxNumSegments == that.indexOptimizationMaxNumSegments() && this.indexOptimizationDisabled == that.indexOptimizationDisabled() && this.fieldTypeRefreshInterval.equals((Object)that.fieldTypeRefreshInterval());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.id == null ? 0 : this.id.hashCode();
        h$ *= 1000003;
        h$ ^= this.title.hashCode();
        h$ *= 1000003;
        h$ ^= this.description == null ? 0 : this.description.hashCode();
        h$ *= 1000003;
        h$ ^= this.isWritable ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.indexPrefix.hashCode();
        h$ *= 1000003;
        h$ ^= this.indexMatchPattern == null ? 0 : this.indexMatchPattern.hashCode();
        h$ *= 1000003;
        h$ ^= this.indexWildcard == null ? 0 : this.indexWildcard.hashCode();
        h$ *= 1000003;
        h$ ^= this.shards;
        h$ *= 1000003;
        h$ ^= this.replicas;
        h$ *= 1000003;
        h$ ^= this.rotationStrategyClass == null ? 0 : this.rotationStrategyClass.hashCode();
        h$ *= 1000003;
        h$ ^= this.rotationStrategy.hashCode();
        h$ *= 1000003;
        h$ ^= this.retentionStrategyClass == null ? 0 : this.retentionStrategyClass.hashCode();
        h$ *= 1000003;
        h$ ^= this.retentionStrategy.hashCode();
        h$ *= 1000003;
        h$ ^= this.creationDate.hashCode();
        h$ *= 1000003;
        h$ ^= this.indexAnalyzer.hashCode();
        h$ *= 1000003;
        h$ ^= this.indexTemplateName.hashCode();
        h$ *= 1000003;
        h$ ^= this.indexOptimizationMaxNumSegments;
        h$ *= 1000003;
        h$ ^= this.indexOptimizationDisabled ? 1231 : 1237;
        h$ *= 1000003;
        return h$ ^= this.fieldTypeRefreshInterval.hashCode();
    }

    @Override
    public IndexSetConfig.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends IndexSetConfig.Builder {
        private String id;
        @NotBlank
        private String title;
        private String description;
        private Boolean isWritable;
        @NotBlank
        @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$")
        private @NotBlank @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$") String indexPrefix;
        private String indexMatchPattern;
        private String indexWildcard;
        private Integer shards;
        private Integer replicas;
        private String rotationStrategyClass;
        @NotNull
        private RotationStrategyConfig rotationStrategy;
        private String retentionStrategyClass;
        @NotNull
        private RetentionStrategyConfig retentionStrategy;
        @NotNull
        private ZonedDateTime creationDate;
        @NotBlank
        private String indexAnalyzer;
        @NotBlank
        private String indexTemplateName;
        private Integer indexOptimizationMaxNumSegments;
        private Boolean indexOptimizationDisabled;
        private Duration fieldTypeRefreshInterval;

        Builder() {
        }

        private Builder(IndexSetConfig source) {
            this.id = source.id();
            this.title = source.title();
            this.description = source.description();
            this.isWritable = source.isWritable();
            this.indexPrefix = source.indexPrefix();
            this.indexMatchPattern = source.indexMatchPattern();
            this.indexWildcard = source.indexWildcard();
            this.shards = source.shards();
            this.replicas = source.replicas();
            this.rotationStrategyClass = source.rotationStrategyClass();
            this.rotationStrategy = source.rotationStrategy();
            this.retentionStrategyClass = source.retentionStrategyClass();
            this.retentionStrategy = source.retentionStrategy();
            this.creationDate = source.creationDate();
            this.indexAnalyzer = source.indexAnalyzer();
            this.indexTemplateName = source.indexTemplateName();
            this.indexOptimizationMaxNumSegments = source.indexOptimizationMaxNumSegments();
            this.indexOptimizationDisabled = source.indexOptimizationDisabled();
            this.fieldTypeRefreshInterval = source.fieldTypeRefreshInterval();
        }

        @Override
        public IndexSetConfig.Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public IndexSetConfig.Builder title(String title) {
            if (title == null) {
                throw new NullPointerException("Null title");
            }
            this.title = title;
            return this;
        }

        @Override
        public IndexSetConfig.Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public IndexSetConfig.Builder isWritable(boolean isWritable) {
            this.isWritable = isWritable;
            return this;
        }

        @Override
        public IndexSetConfig.Builder indexPrefix(String indexPrefix) {
            if (indexPrefix == null) {
                throw new NullPointerException("Null indexPrefix");
            }
            this.indexPrefix = indexPrefix;
            return this;
        }

        @Override
        public IndexSetConfig.Builder indexMatchPattern(String indexMatchPattern) {
            this.indexMatchPattern = indexMatchPattern;
            return this;
        }

        @Override
        public IndexSetConfig.Builder indexWildcard(String indexWildcard) {
            this.indexWildcard = indexWildcard;
            return this;
        }

        @Override
        public IndexSetConfig.Builder shards(int shards) {
            this.shards = shards;
            return this;
        }

        @Override
        public IndexSetConfig.Builder replicas(int replicas) {
            this.replicas = replicas;
            return this;
        }

        @Override
        public IndexSetConfig.Builder rotationStrategyClass(String rotationStrategyClass) {
            this.rotationStrategyClass = rotationStrategyClass;
            return this;
        }

        @Override
        public IndexSetConfig.Builder rotationStrategy(RotationStrategyConfig rotationStrategy) {
            if (rotationStrategy == null) {
                throw new NullPointerException("Null rotationStrategy");
            }
            this.rotationStrategy = rotationStrategy;
            return this;
        }

        @Override
        public IndexSetConfig.Builder retentionStrategyClass(String retentionStrategyClass) {
            this.retentionStrategyClass = retentionStrategyClass;
            return this;
        }

        @Override
        public IndexSetConfig.Builder retentionStrategy(RetentionStrategyConfig retentionStrategy) {
            if (retentionStrategy == null) {
                throw new NullPointerException("Null retentionStrategy");
            }
            this.retentionStrategy = retentionStrategy;
            return this;
        }

        @Override
        public IndexSetConfig.Builder creationDate(ZonedDateTime creationDate) {
            if (creationDate == null) {
                throw new NullPointerException("Null creationDate");
            }
            this.creationDate = creationDate;
            return this;
        }

        @Override
        public IndexSetConfig.Builder indexAnalyzer(String indexAnalyzer) {
            if (indexAnalyzer == null) {
                throw new NullPointerException("Null indexAnalyzer");
            }
            this.indexAnalyzer = indexAnalyzer;
            return this;
        }

        @Override
        public IndexSetConfig.Builder indexTemplateName(String indexTemplateName) {
            if (indexTemplateName == null) {
                throw new NullPointerException("Null indexTemplateName");
            }
            this.indexTemplateName = indexTemplateName;
            return this;
        }

        @Override
        public IndexSetConfig.Builder indexOptimizationMaxNumSegments(int indexOptimizationMaxNumSegments) {
            this.indexOptimizationMaxNumSegments = indexOptimizationMaxNumSegments;
            return this;
        }

        @Override
        public IndexSetConfig.Builder indexOptimizationDisabled(boolean indexOptimizationDisabled) {
            this.indexOptimizationDisabled = indexOptimizationDisabled;
            return this;
        }

        @Override
        public IndexSetConfig.Builder fieldTypeRefreshInterval(Duration fieldTypeRefreshInterval) {
            if (fieldTypeRefreshInterval == null) {
                throw new NullPointerException("Null fieldTypeRefreshInterval");
            }
            this.fieldTypeRefreshInterval = fieldTypeRefreshInterval;
            return this;
        }

        @Override
        public IndexSetConfig build() {
            String missing = "";
            if (this.title == null) {
                missing = missing + " title";
            }
            if (this.isWritable == null) {
                missing = missing + " isWritable";
            }
            if (this.indexPrefix == null) {
                missing = missing + " indexPrefix";
            }
            if (this.shards == null) {
                missing = missing + " shards";
            }
            if (this.replicas == null) {
                missing = missing + " replicas";
            }
            if (this.rotationStrategy == null) {
                missing = missing + " rotationStrategy";
            }
            if (this.retentionStrategy == null) {
                missing = missing + " retentionStrategy";
            }
            if (this.creationDate == null) {
                missing = missing + " creationDate";
            }
            if (this.indexAnalyzer == null) {
                missing = missing + " indexAnalyzer";
            }
            if (this.indexTemplateName == null) {
                missing = missing + " indexTemplateName";
            }
            if (this.indexOptimizationMaxNumSegments == null) {
                missing = missing + " indexOptimizationMaxNumSegments";
            }
            if (this.indexOptimizationDisabled == null) {
                missing = missing + " indexOptimizationDisabled";
            }
            if (this.fieldTypeRefreshInterval == null) {
                missing = missing + " fieldTypeRefreshInterval";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_IndexSetConfig(this.id, this.title, this.description, this.isWritable, this.indexPrefix, this.indexMatchPattern, this.indexWildcard, this.shards, this.replicas, this.rotationStrategyClass, this.rotationStrategy, this.retentionStrategyClass, this.retentionStrategy, this.creationDate, this.indexAnalyzer, this.indexTemplateName, this.indexOptimizationMaxNumSegments, this.indexOptimizationDisabled, this.fieldTypeRefreshInterval);
        }
    }
}

