/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.indexset;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.base.Strings;
import com.google.common.collect.ComparisonChain;
import java.time.ZonedDateTime;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.graylog2.indexer.indexset.$AutoValue_IndexSetConfig;
import org.graylog2.indexer.indexset.AutoValue_IndexSetConfig;
import org.graylog2.plugin.indexer.retention.RetentionStrategyConfig;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;
import org.joda.time.Duration;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@JsonAutoDetect
@JsonIgnoreProperties(value={"default"})
@AutoValue
public abstract class IndexSetConfig
implements Comparable<IndexSetConfig> {
    public static final String FIELD_INDEX_PREFIX = "index_prefix";
    public static final String FIELD_CREATION_DATE = "creation_date";
    public static final String INDEX_PREFIX_REGEX = "^[a-z0-9][a-z0-9_+-]*$";
    private static final Duration DEFAULT_FIELD_TYPE_REFRESH_INTERVAL = Duration.standardSeconds((long)5L);

    @JsonProperty(value="id")
    @Nullable
    @Id
    @ObjectId
    public abstract String id();

    @JsonProperty(value="title")
    @NotBlank
    public abstract String title();

    @JsonProperty(value="description")
    @Nullable
    public abstract String description();

    @JsonProperty(value="writable")
    public abstract boolean isWritable();

    @JsonProperty(value="index_prefix")
    @NotBlank
    @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$")
    public abstract @NotBlank @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$") String indexPrefix();

    @JsonProperty(value="index_match_pattern")
    @Nullable
    public abstract String indexMatchPattern();

    @JsonProperty(value="index_wildcard")
    @Nullable
    public abstract String indexWildcard();

    @JsonProperty(value="shards")
    @Min(value=1L)
    public abstract @Min(value=1L) int shards();

    @JsonProperty(value="replicas")
    @Min(value=0L)
    public abstract @Min(value=0L) int replicas();

    @JsonProperty(value="rotation_strategy_class")
    @Nullable
    public abstract String rotationStrategyClass();

    @JsonProperty(value="rotation_strategy")
    @NotNull
    public abstract RotationStrategyConfig rotationStrategy();

    @JsonProperty(value="retention_strategy_class")
    @Nullable
    public abstract String retentionStrategyClass();

    @JsonProperty(value="retention_strategy")
    @NotNull
    public abstract RetentionStrategyConfig retentionStrategy();

    @JsonProperty(value="creation_date")
    @NotNull
    public abstract ZonedDateTime creationDate();

    @JsonProperty(value="index_analyzer")
    @NotBlank
    public abstract String indexAnalyzer();

    @JsonProperty(value="index_template_name")
    @NotBlank
    public abstract String indexTemplateName();

    @JsonProperty(value="index_optimization_max_num_segments")
    @Min(value=1L)
    public abstract @Min(value=1L) int indexOptimizationMaxNumSegments();

    @JsonProperty(value="index_optimization_disabled")
    public abstract boolean indexOptimizationDisabled();

    @JsonProperty(value="field_type_refresh_interval")
    public abstract Duration fieldTypeRefreshInterval();

    @JsonCreator
    public static IndexSetConfig create(@Id @ObjectId @JsonProperty(value="_id") @Nullable String id, @JsonProperty(value="title") @NotBlank String title, @JsonProperty(value="description") @Nullable String description, @JsonProperty(value="writable") @Nullable Boolean isWritable, @JsonProperty(value="index_prefix") @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$") @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$") String indexPrefix, @JsonProperty(value="index_match_pattern") @Nullable String indexMatchPattern, @JsonProperty(value="index_wildcard") @Nullable String indexWildcard, @JsonProperty(value="shards") @Min(value=1L) @Min(value=1L) int shards, @JsonProperty(value="replicas") @Min(value=0L) @Min(value=0L) int replicas, @JsonProperty(value="rotation_strategy_class") @Nullable String rotationStrategyClass, @JsonProperty(value="rotation_strategy") @NotNull RotationStrategyConfig rotationStrategy, @JsonProperty(value="retention_strategy_class") @Nullable String retentionStrategyClass, @JsonProperty(value="retention_strategy") @NotNull RetentionStrategyConfig retentionStrategy, @JsonProperty(value="creation_date") @NotNull ZonedDateTime creationDate, @JsonProperty(value="index_analyzer") @Nullable String indexAnalyzer, @JsonProperty(value="index_template_name") @Nullable String indexTemplateName, @JsonProperty(value="index_optimization_max_num_segments") @Nullable Integer maxNumSegments, @JsonProperty(value="index_optimization_disabled") @Nullable Boolean indexOptimizationDisabled, @JsonProperty(value="field_type_refresh_interval") @Nullable Duration fieldTypeRefreshInterval) {
        boolean writableValue = isWritable == null ? true : isWritable;
        Duration fieldTypeRefreshIntervalValue = fieldTypeRefreshInterval;
        if (fieldTypeRefreshIntervalValue == null) {
            fieldTypeRefreshIntervalValue = writableValue ? DEFAULT_FIELD_TYPE_REFRESH_INTERVAL : Duration.ZERO;
        }
        return AutoValue_IndexSetConfig.builder().id(id).title(title).description(description).isWritable(writableValue).indexPrefix(indexPrefix).indexMatchPattern(indexMatchPattern).indexWildcard(indexWildcard).shards(shards).replicas(replicas).rotationStrategyClass(rotationStrategyClass).rotationStrategy(rotationStrategy).retentionStrategyClass(retentionStrategyClass).retentionStrategy(retentionStrategy).creationDate(creationDate).indexAnalyzer(Strings.isNullOrEmpty((String)indexAnalyzer) ? "standard" : indexAnalyzer).indexTemplateName(Strings.isNullOrEmpty((String)indexTemplateName) ? indexPrefix + "-template" : indexTemplateName).indexOptimizationMaxNumSegments(maxNumSegments == null ? 1 : maxNumSegments).indexOptimizationDisabled(indexOptimizationDisabled == null ? false : indexOptimizationDisabled).fieldTypeRefreshInterval(fieldTypeRefreshIntervalValue).build();
    }

    public static IndexSetConfig create(String id, String title, String description, boolean isWritable, String indexPrefix, int shards, int replicas, String rotationStrategyClass, RotationStrategyConfig rotationStrategy, String retentionStrategyClass, RetentionStrategyConfig retentionStrategy, ZonedDateTime creationDate, String indexAnalyzer, String indexTemplateName, int indexOptimizationMaxNumSegments, boolean indexOptimizationDisabled, Duration fieldTypeRefreshInterval) {
        return IndexSetConfig.create(id, title, description, isWritable, indexPrefix, null, null, shards, replicas, rotationStrategyClass, rotationStrategy, retentionStrategyClass, retentionStrategy, creationDate, indexAnalyzer, indexTemplateName, indexOptimizationMaxNumSegments, indexOptimizationDisabled, fieldTypeRefreshInterval);
    }

    public static IndexSetConfig create(String title, String description, boolean isWritable, String indexPrefix, int shards, int replicas, String rotationStrategyClass, RotationStrategyConfig rotationStrategy, String retentionStrategyClass, RetentionStrategyConfig retentionStrategy, ZonedDateTime creationDate, String indexAnalyzer, String indexTemplateName, int indexOptimizationMaxNumSegments, boolean indexOptimizationDisabled, Duration fieldTypeRefreshInterval) {
        return IndexSetConfig.create(null, title, description, isWritable, indexPrefix, null, null, shards, replicas, rotationStrategyClass, rotationStrategy, retentionStrategyClass, retentionStrategy, creationDate, indexAnalyzer, indexTemplateName, indexOptimizationMaxNumSegments, indexOptimizationDisabled, fieldTypeRefreshInterval);
    }

    public static IndexSetConfig create(String id, String title, String description, boolean isWritable, String indexPrefix, int shards, int replicas, String rotationStrategyClass, RotationStrategyConfig rotationStrategy, String retentionStrategyClass, RetentionStrategyConfig retentionStrategy, ZonedDateTime creationDate, String indexAnalyzer, String indexTemplateName, int indexOptimizationMaxNumSegments, boolean indexOptimizationDisabled) {
        return IndexSetConfig.create(id, title, description, isWritable, indexPrefix, null, null, shards, replicas, rotationStrategyClass, rotationStrategy, retentionStrategyClass, retentionStrategy, creationDate, indexAnalyzer, indexTemplateName, indexOptimizationMaxNumSegments, indexOptimizationDisabled, DEFAULT_FIELD_TYPE_REFRESH_INTERVAL);
    }

    public static IndexSetConfig create(String title, String description, boolean isWritable, String indexPrefix, int shards, int replicas, String rotationStrategyClass, RotationStrategyConfig rotationStrategy, String retentionStrategyClass, RetentionStrategyConfig retentionStrategy, ZonedDateTime creationDate, String indexAnalyzer, String indexTemplateName, int indexOptimizationMaxNumSegments, boolean indexOptimizationDisabled) {
        return IndexSetConfig.create(null, title, description, isWritable, indexPrefix, null, null, shards, replicas, rotationStrategyClass, rotationStrategy, retentionStrategyClass, retentionStrategy, creationDate, indexAnalyzer, indexTemplateName, indexOptimizationMaxNumSegments, indexOptimizationDisabled, DEFAULT_FIELD_TYPE_REFRESH_INTERVAL);
    }

    @Override
    public int compareTo(IndexSetConfig o) {
        return ComparisonChain.start().compare((Comparable)((Object)this.title()), (Comparable)((Object)o.title())).compare((Comparable)((Object)this.indexPrefix()), (Comparable)((Object)o.indexPrefix())).compare((Comparable)this.creationDate(), (Comparable)o.creationDate()).result();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new $AutoValue_IndexSetConfig.Builder().isWritable(true).fieldTypeRefreshInterval(DEFAULT_FIELD_TYPE_REFRESH_INTERVAL);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder id(String var1);

        public abstract Builder title(String var1);

        public abstract Builder description(String var1);

        public abstract Builder isWritable(boolean var1);

        public abstract Builder indexPrefix(String var1);

        public abstract Builder indexMatchPattern(String var1);

        public abstract Builder indexWildcard(String var1);

        public abstract Builder shards(int var1);

        public abstract Builder replicas(int var1);

        public abstract Builder rotationStrategyClass(String var1);

        public abstract Builder rotationStrategy(RotationStrategyConfig var1);

        public abstract Builder retentionStrategyClass(String var1);

        public abstract Builder retentionStrategy(RetentionStrategyConfig var1);

        public abstract Builder creationDate(ZonedDateTime var1);

        public abstract Builder indexAnalyzer(String var1);

        public abstract Builder indexTemplateName(String var1);

        public abstract Builder indexOptimizationMaxNumSegments(int var1);

        public abstract Builder indexOptimizationDisabled(boolean var1);

        public abstract Builder fieldTypeRefreshInterval(Duration var1);

        public abstract IndexSetConfig build();
    }
}

