/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.transports;

import com.github.joschi.jadconfig.Parameter;
import com.github.joschi.jadconfig.validators.PositiveIntegerValidator;
import com.github.joschi.jadconfig.validators.StringNotBlankValidator;
import com.google.common.annotations.VisibleForTesting;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.kqueue.KQueue;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslProvider;
import java.util.Locale;
import org.graylog2.inputs.transports.netty.NettyTransportType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyTransportConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(NettyTransportConfiguration.class);
    private static final String PREFIX = "transport_netty_";
    @Parameter(value="transport_netty_type", required=true, validators={StringNotBlankValidator.class})
    private String type = "auto";
    @Parameter(value="transport_netty_tls_provider", required=true, validators={StringNotBlankValidator.class})
    private String tlsProvider = "auto";
    @Parameter(value="transport_netty_num_threads", required=true, validators={PositiveIntegerValidator.class})
    private int numThreads = Runtime.getRuntime().availableProcessors() * 2;

    public NettyTransportConfiguration() {
    }

    @VisibleForTesting
    public NettyTransportConfiguration(String type, String tlsProvider, int numThreads) {
        this.type = type;
        this.tlsProvider = tlsProvider;
        this.numThreads = numThreads;
    }

    public NettyTransportType getType() {
        switch (this.type.toLowerCase(Locale.ROOT)) {
            case "epoll": {
                return NettyTransportType.EPOLL;
            }
            case "kqueue": {
                return NettyTransportType.KQUEUE;
            }
            case "nio": {
                return NettyTransportType.NIO;
            }
        }
        return this.detectPlatform();
    }

    private NettyTransportType detectPlatform() {
        if (Epoll.isAvailable()) {
            LOG.debug("Using epoll for Netty transport.");
            return NettyTransportType.EPOLL;
        }
        if (KQueue.isAvailable()) {
            LOG.debug("Using kqueue for Netty transport.");
            return NettyTransportType.KQUEUE;
        }
        LOG.debug("Using NIO for Netty transport.");
        return NettyTransportType.NIO;
    }

    public SslProvider getTlsProvider() {
        switch (this.tlsProvider.toLowerCase(Locale.ROOT)) {
            case "openssl": {
                return SslProvider.OPENSSL;
            }
            case "jdk": {
                return SslProvider.JDK;
            }
        }
        return this.detectTlsProvider();
    }

    private SslProvider detectTlsProvider() {
        if (OpenSsl.isAvailable()) {
            LOG.debug("Using OpenSSL for Netty transports.");
            return SslProvider.OPENSSL;
        }
        LOG.debug("Using default Java TLS provider for Netty transports.");
        return SslProvider.JDK;
    }

    public int getNumThreads() {
        return this.numThreads;
    }
}

