/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.transports;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.graylog2.inputs.random.generators.FakeHttpRawMessageGenerator;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.NumberField;
import org.graylog2.plugin.configuration.fields.TextField;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.inputs.annotations.ConfigClass;
import org.graylog2.plugin.inputs.annotations.FactoryClass;
import org.graylog2.plugin.inputs.transports.GeneratorTransport;
import org.graylog2.plugin.inputs.transports.Transport;
import org.graylog2.plugin.journal.RawMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomMessageTransport
extends GeneratorTransport {
    private static final Logger log = LoggerFactory.getLogger(RandomMessageTransport.class);
    public static final String CK_SOURCE = "source";
    public static final String CK_SLEEP = "sleep";
    public static final String CK_SLEEP_DEVIATION_PERCENT = "sleep_deviation";
    private final Random rand = new Random();
    private final FakeHttpRawMessageGenerator generator;
    private final int sleepMs;
    private final int maxSleepDeviation;
    private final ObjectMapper objectMapper;

    @AssistedInject
    public RandomMessageTransport(@Assisted Configuration configuration, EventBus eventBus, ObjectMapper objectMapper) {
        super(eventBus, configuration);
        this.objectMapper = objectMapper;
        this.generator = new FakeHttpRawMessageGenerator(configuration.getString(CK_SOURCE));
        this.sleepMs = configuration.intIsSet(CK_SLEEP) ? configuration.getInt(CK_SLEEP) : 0;
        this.maxSleepDeviation = configuration.intIsSet(CK_SLEEP_DEVIATION_PERCENT) ? configuration.getInt(CK_SLEEP_DEVIATION_PERCENT) : 0;
    }

    @Override
    protected RawMessage produceRawMessage(MessageInput input) {
        try {
            FakeHttpRawMessageGenerator.GeneratorState state = this.generator.generateState();
            byte[] payload = this.objectMapper.writeValueAsBytes((Object)state);
            RawMessage raw = new RawMessage(payload);
            Uninterruptibles.sleepUninterruptibly((long)FakeHttpRawMessageGenerator.rateDeviation(this.sleepMs, this.maxSleepDeviation, this.rand), (TimeUnit)TimeUnit.MILLISECONDS);
            return raw;
        }
        catch (JsonProcessingException e) {
            log.error("Unable to serialize generator state", (Throwable)e);
            return null;
        }
    }

    @ConfigClass
    public static class Config
    extends GeneratorTransport.Config {
        @Override
        public ConfigurationRequest getRequestedConfiguration() {
            ConfigurationRequest c = super.getRequestedConfiguration();
            c.addField(new NumberField(RandomMessageTransport.CK_SLEEP, "Sleep time", 25, "How many milliseconds to sleep between generating messages.", ConfigurationField.Optional.NOT_OPTIONAL, NumberField.Attribute.ONLY_POSITIVE));
            c.addField(new NumberField(RandomMessageTransport.CK_SLEEP_DEVIATION_PERCENT, "Maximum random sleep time deviation", 30, "The deviation is used to generate a more realistic and non-steady message flow.", ConfigurationField.Optional.NOT_OPTIONAL, NumberField.Attribute.ONLY_POSITIVE));
            c.addField(new TextField(RandomMessageTransport.CK_SOURCE, "Source name", "example.org", "What to use as source of the generate messages.", ConfigurationField.Optional.NOT_OPTIONAL));
            return c;
        }
    }

    @FactoryClass
    public static interface Factory
    extends Transport.Factory<RandomMessageTransport> {
        @Override
        public RandomMessageTransport create(Configuration var1);

        @Override
        public Config getConfig();
    }
}

