/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.transports;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.Delimiters;
import java.util.LinkedHashMap;
import java.util.concurrent.Callable;
import org.graylog2.inputs.transports.NettyTransportConfiguration;
import org.graylog2.inputs.transports.netty.EventLoopGroupFactory;
import org.graylog2.inputs.transports.netty.LenientDelimiterBasedFrameDecoder;
import org.graylog2.plugin.LocalMetricRegistry;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.BooleanField;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.NumberField;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.inputs.annotations.ConfigClass;
import org.graylog2.plugin.inputs.annotations.FactoryClass;
import org.graylog2.plugin.inputs.transports.AbstractTcpTransport;
import org.graylog2.plugin.inputs.transports.Transport;
import org.graylog2.plugin.inputs.util.ThroughputCounter;

public class TcpTransport
extends AbstractTcpTransport {
    public static final String CK_USE_NULL_DELIMITER = "use_null_delimiter";
    private static final String CK_MAX_MESSAGE_SIZE = "max_message_size";
    private static final int DEFAULT_MAX_FRAME_LENGTH = 0x200000;
    protected final ByteBuf[] delimiter;
    protected final int maxFrameLength;

    @AssistedInject
    public TcpTransport(@Assisted Configuration configuration, EventLoopGroup eventLoopGroup, EventLoopGroupFactory eventLoopGroupFactory, NettyTransportConfiguration nettyTransportConfiguration, ThroughputCounter throughputCounter, LocalMetricRegistry localRegistry) {
        super(configuration, throughputCounter, localRegistry, eventLoopGroup, eventLoopGroupFactory, nettyTransportConfiguration);
        boolean nulDelimiter = configuration.getBoolean(CK_USE_NULL_DELIMITER);
        this.delimiter = nulDelimiter ? Delimiters.nulDelimiter() : Delimiters.lineDelimiter();
        this.maxFrameLength = configuration.getInt(CK_MAX_MESSAGE_SIZE, 0x200000);
    }

    @Override
    protected LinkedHashMap<String, Callable<? extends ChannelHandler>> getCustomChildChannelHandlers(MessageInput input) {
        LinkedHashMap<String, Callable<? extends ChannelHandler>> childChannelHandlers = new LinkedHashMap<String, Callable<? extends ChannelHandler>>();
        childChannelHandlers.put("framer", () -> new LenientDelimiterBasedFrameDecoder(this.maxFrameLength, this.delimiter));
        childChannelHandlers.putAll(super.getCustomChildChannelHandlers(input));
        return childChannelHandlers;
    }

    @ConfigClass
    public static class Config
    extends AbstractTcpTransport.Config {
        @Override
        public ConfigurationRequest getRequestedConfiguration() {
            ConfigurationRequest x = super.getRequestedConfiguration();
            x.addField(new BooleanField(TcpTransport.CK_USE_NULL_DELIMITER, "Null frame delimiter?", false, "Use null byte as frame delimiter? Otherwise newline delimiter is used."));
            x.addField(new NumberField(TcpTransport.CK_MAX_MESSAGE_SIZE, "Maximum message size", 0x200000, "The maximum length of a message.", ConfigurationField.Optional.OPTIONAL, NumberField.Attribute.ONLY_POSITIVE));
            return x;
        }
    }

    @FactoryClass
    public static interface Factory
    extends Transport.Factory<TcpTransport> {
        @Override
        public TcpTransport create(Configuration var1);

        @Override
        public Config getConfig();
    }
}

