/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.IOException;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class MongoJodaDateTimeDeserializer
extends StdScalarDeserializer<DateTime> {
    private static final DateTimeFormatter FORMATTER = ISODateTimeFormat.dateTime();

    public MongoJodaDateTimeDeserializer() {
        super(DateTime.class);
    }

    public DateTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        switch (jsonParser.currentToken()) {
            case VALUE_EMBEDDED_OBJECT: {
                Object embeddedObject = jsonParser.getEmbeddedObject();
                if (embeddedObject instanceof Date) {
                    Date date = (Date)embeddedObject;
                    return new DateTime((Object)date, DateTimeZone.UTC);
                }
                throw new IllegalStateException("Unsupported token: " + jsonParser.currentToken());
            }
            case VALUE_STRING: {
                String text = jsonParser.getText();
                return DateTime.parse((String)text, (DateTimeFormatter)FORMATTER).withZone(DateTimeZone.UTC);
            }
        }
        throw new IllegalStateException("Unsupported token: " + jsonParser.currentToken());
    }
}

